#ifndef _MAP_H_
#define _MAP_H_

#include <stdarg.h>
#include "mmo.h"

#define MAX_PC_CLASS (1+6+6+1+6+1)
#define MAX_NPC_PER_MAP 512
#define BLOCK_SIZE 8
#define AREA_SIZE 15
#define LOCAL_REG_NUM 16
#define LIFETIME_FLOORITEM 60
#define DAMAGELOG_SIZE 16
#define LOOTITEM_SIZE 10

enum { BL_NUL, BL_PC, BL_NPC, BL_MOB, BL_ITEM, BL_CHAT };
enum { WARP, SHOP, SCRIPT, MONS };
struct block_list {
	struct block_list *next,*prev;
	int id;
	short m,x,y;
	unsigned char type;
	unsigned char subtype;
};

struct walkpath_data {
	unsigned char path_len,path_pos,path_half;
	unsigned char path[32];
};
struct script_reg {
	int index;
	int data;
};
struct map_session_data {
	struct block_list bl;
	struct {
		unsigned auth : 1 ;
		unsigned change_walk_target : 1 ;
		unsigned attack_continue : 1 ;
		unsigned menu_or_input : 1;
	} state;
	int char_id,login_id1,login_id2,sex;
	struct mmo_charstatus status;
	int weight,max_weight;
	char mapname[16];
	int fd,new_fd;
	short to_x,to_y;
	short speed;
	short opt1,opt2;
	char dead_sit,dir,head_dir;
	unsigned long client_tick,server_tick;
	struct walkpath_data walkpath;
	int walktimer;
	int npc_id;
	int npc_pos;
	int npc_menu;
	int npc_amount;
	unsigned long chatID;

	int attacktimer;
	int attacktarget;
	unsigned int attackabletime;

	int attackrange;
	int skilltimer;
	int skilltarget;
	short skillx,skilly;
	short skillid,skilllv;
	unsigned long canmove_tick;
	int hp_sub,sp_sub;

	int paramb[6],paramc[6];
	int hit,flee,aspd,amotion,dmotion;
	int watk,atkmods[3],atkmodr[16],atkmoda[16];
	int def,mdef;

	int reg_num;
	struct script_reg *reg;
};
struct npc_item_list {
	int nameid,value;
};
struct npc_data {
	struct block_list bl;
	short n;
	short class,dir;
	char name[24];
	union {
		struct {
			char *script;
			short xs,ys;
		} scr;
		struct npc_item_list shop_item[1];
		struct {
			short xs,ys;
			short x,y;
			char name[16];
		} warp;
	} u;
};
struct mob_data {
	struct block_list bl;
	short n;
	short class,dir;
	short x0,y0,xs,ys;
	char name[24];
	int spawndelay1,spawndelay2;
	int state;
	int timer;
	short to_x,to_y;
	int speed;
	int hp;
	int target_id,attacked_id;
	struct walkpath_data walkpath;
	unsigned int next_walktime;
	unsigned int last_deadtime,last_spawntime,last_thinktime;
	int move_fail_count;
	struct {
		int id;
		int dmg;
	} dmglog[DAMAGELOG_SIZE];
	struct item lootitem[LOOTITEM_SIZE];
};
enum { MS_IDLE,MS_WALK,MS_ATTACK,MS_DEAD };

struct map_data {
	char name[16];
	unsigned char *gat;	// NULLʤ鲼map_data_other_serverȤư
	struct block_list **block,**block_mob;
	int m;
	short xs,ys;
	short bxs,bys;
	int npc_num;
	int users;
	struct npc_data *npc[MAX_NPC_PER_MAP];
};
struct map_data_other_server {
	char name[16];
	unsigned char *gat;	// NULLˤȽ
	unsigned long ip;
	unsigned int port;
};
#define read_gat(m,x,y) (map[m].gat[(x)+(y)*map[m].xs])
#define read_gatp(m,x,y) (m->gat[(x)+(y)*m->xs])

struct flooritem_data {
	struct block_list bl;
	short subx,suby;
	int cleartimer;
	struct item item_data;
};

enum {
	SP_SPEED,SP_BASEEXP,SP_JOBEXP,SP_KARMA,SP_MANNER,SP_HP,SP_MAXHP,SP_SP,
	SP_MAXSP,SP_STATUSPOINT,SP_0a,SP_BASELEVEL,SP_SKILLPOINT,SP_STR,SP_AGI,SP_VIT,
	SP_INT,SP_DEX,SP_LUK,SP_CLASS,SP_ZENY,SP_SEX,SP_NEXTBASEEXP,SP_NEXTJOBEXP,
	SP_WEIGHT,SP_MAXWEIGHT,SP_1a,SP_1b,SP_1c,SP_1d,SP_1e,SP_1f,
	SP_USTR,SP_UAGI,SP_UVIT,SP_UINT,SP_UDEX,SP_ULUK,SP_26,SP_27,
	SP_28,SP_ATK1,SP_ATK2,SP_MATK1,SP_MATK2,SP_DEF1,SP_DEF2,SP_MDEF1,
	SP_MDEF2,SP_HIT,SP_FLEE1,SP_FLEE2,SP_CRITICAL,SP_ASPD,SP_36,SP_JOBLEVEL,
	// original
	SP_ATTACKRANGE
};

enum {
	LOOK_BASE,LOOK_HAIR,LOOK_WEAPON,LOOK_HEAD_BOTTOM,LOOK_HEAD_TOP,LOOK_HEAD_MID,LOOK_HAIR_COLOR,LOOK_CLOTHES_COLOR,LOOK_SHEILD
};

struct chat_data {
	struct block_list bl;

	unsigned char pass[8];   /* password */
	unsigned char title[61]; /* room title MAX 60 */
	unsigned char limit;     /* join limit */
	unsigned char users;     /* current users */
	unsigned char pub;       /* room attribute */
	struct map_session_data *usersd[20];
};

struct mons_data {
	int type;
	int max_hp;
	int npc_num;
	int job_exp;
	int base_exp;
	int atk;
	int hit;
	int flee;
	int def;
	struct {
		int nameid,p;
	} dropitem[16];
};

extern struct map_data map[];
extern int map_num;

// ξ
void map_setusers(int);
int map_getusers(void);
// blockϢ
int map_addblock(struct block_list *);
int map_delblock(struct block_list *);
void map_foreachinarea(int (*)(struct block_list*,va_list),int,int,int,int,int,int,...);
void map_foreachinmovearea(int (*)(struct block_list*,va_list),int,int,int,int,int,int,int,int,...);
int map_countnearpc(int,int,int);
// ŪobjectϢ
int map_addobject(struct block_list *);
int map_delobject(int);
void map_foreachobject(int (*)(struct block_list*,va_list),int,...);
//
int map_quit(struct map_session_data *);
// npc
int map_addnpc(int,struct npc_data *);

// ƥϢ
int map_clearflooritem_timer(int,unsigned int,int,int);
#define map_clearflooritem(id) map_clearflooritem_timer(0,0,id,1)
int map_addflooritem(struct item *,int,int,int,int);

struct map_session_data * map_id2sd(int);
struct block_list * map_id2bl(int);
int map_mapname2mapid(char*);
int map_mapname2ipport(char*,int*,int*);
void map_addiddb(struct block_list *);
int map_foreachiddb(int (*)(void*,void*,va_list),...);
void map_addnickdb(struct map_session_data *);
struct map_session_data * map_nick2sd(char*);

// gatϢ
int map_getcell(int,int,int);
int map_setcell(int,int,int,int);

// path.c
int path_search(struct walkpath_data*,int,int,int,int,int,int);

#endif
