// $Id: npc.c,v 1.12 2003/07/01 00:29:54 lemit Exp $
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "map.h"
#include "npc.h"
#include "clif.h"
#include "pc.h"
#include "itemdb.h"
#include "script.h"
#include "mob.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

struct npc_src_list {
	struct npc_src_list * next;
	char name[4];
} ;

static struct npc_src_list *npc_src_first,*npc_src_last;
static int npc_id=50000;
static int npc_warp,npc_shop,npc_script,npc_mob;

/*==========================================
 *
 *------------------------------------------
 */
int npc_touch_areanpc(struct map_session_data *sd,int m,int x,int y)
{
	int i;
	int xs,ys;

	for(i=0;i<map[m].npc_num;i++){
		switch(map[m].npc[i]->bl.subtype){
		case WARP:
			xs=map[m].npc[i]->u.warp.xs;
			ys=map[m].npc[i]->u.warp.ys;
			break;
		case SCRIPT:
			xs=map[m].npc[i]->u.scr.xs;
			ys=map[m].npc[i]->u.scr.ys;
			break;
		default:
			continue;
		}
		if(x >= map[m].npc[i]->bl.x-xs/2 && x < map[m].npc[i]->bl.x-xs/2+xs &&
		   y >= map[m].npc[i]->bl.y-ys/2 && y < map[m].npc[i]->bl.y-ys/2+ys)
			break;
	}
	if(i==map[m].npc_num){
		printf("npc_touch_areanpc : some bug \n");
		return 1;
	}
	switch(map[m].npc[i]->bl.subtype){
	case WARP:
		pc_setpos(sd,map[m].npc[i]->u.warp.name,map[m].npc[i]->u.warp.x,map[m].npc[i]->u.warp.y,0);
		break;
	case SCRIPT:
		npc_click(sd,map[m].npc[i]->bl.id);
		break;
	}
	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_checknear(struct map_session_data *sd,int id)
{
	struct npc_data *nd;

	nd=(struct npc_data *)map_id2bl(id);
	if(nd==NULL || nd->bl.type!=BL_NPC){
		printf("no such npc : %d\n",id);
		return 1;
	}

	// ꥢȽ
	if(nd->bl.m!=sd->bl.m ||
	   nd->bl.x<sd->bl.x-AREA_SIZE-1 || nd->bl.x>sd->bl.x+AREA_SIZE+1 ||
	   nd->bl.y<sd->bl.y-AREA_SIZE-1 || nd->bl.y>sd->bl.y+AREA_SIZE+1)
		return 1;

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_click(struct map_session_data *sd,int id)
{
	struct npc_data *nd;

#if 0
	if(sd->npc_id != 0){
		sd->npc_id=0;
		return 1;
	}
#endif
	if(npc_checknear(sd,id))
		return 1;

	nd=(struct npc_data *)map_id2bl(id);

	sd->npc_id=id;
	switch(nd->bl.subtype){
	case SHOP:
		clif_npcbuysell(sd,id);
		break;
	case SCRIPT:
		sd->npc_pos=run_script(nd->u.scr.script,0,sd->bl.id,id);
		break;
	}

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_scriptcont(struct map_session_data *sd,int id)
{
	struct npc_data *nd;

	if(id!=sd->npc_id)
		return 1;
	if(npc_checknear(sd,id))
		return 1;

	nd=(struct npc_data *)map_id2bl(id);

	sd->npc_pos=run_script(nd->u.scr.script,sd->npc_pos,sd->bl.id,id);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_buysellsel(struct map_session_data *sd,int id,int type)
{
	struct npc_data *nd;

	if(npc_checknear(sd,id))
		return 1;

	nd=(struct npc_data *)map_id2bl(id);
	if(nd->bl.subtype!=SHOP){
		printf("no such shop npc : %d\n",id);
		sd->npc_id=0;
		return 1;
	}

	if(type==0){
		clif_buylist(sd,nd);
	} else {
		clif_selllist(sd);
	}
	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_buylist(struct map_session_data *sd,int n,unsigned short *item_list)
{
	struct npc_data *nd;
	int i,j,w,z,new=0;

	if(npc_checknear(sd,sd->npc_id))
		return 3;

	nd=(struct npc_data*)map_id2bl(sd->npc_id);
	if(nd->bl.subtype!=SHOP)
		return 3;

	for(i=0,w=z=0;i<n;i++){
		for(j=0;nd->u.shop_item[j].nameid;j++){
			if(nd->u.shop_item[j].nameid==item_list[i*2+1])
				break;
		}
		if(nd->u.shop_item[j].nameid==0)
			return 3;

		z+=pc_modifybuyvalue(sd,nd->u.shop_item[j].value) * item_list[i*2];

		switch(pc_checkadditem(sd,item_list[i*2+1],item_list[i*2])){
		case ADDITEM_EXIST:
			break;
		case ADDITEM_NEW:
			new++;
			break;
		case ADDITEM_OVERAMOUNT:
			return 2;
		}

		w+=itemdb_weight(item_list[i*2+1]) * item_list[i*2];
	}
	if(z > sd->status.zeny)
		return 1;	// zeny­
	if(w+sd->weight > sd->max_weight)
		return 2;	// Ķ
	if(pc_inventoryblank(sd)<new)
		return 3;	// Ķ


	pc_payzeny(sd,z);
	for(i=0;i<n;i++){
		struct item item_tmp;

		memset(&item_tmp,0,sizeof(item_tmp));
		item_tmp.nameid = item_list[i*2+1];
		item_tmp.identify = 1;	// npc䥢ƥϴѤ

		pc_additem(sd,&item_tmp,item_list[i*2]);
	}

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_selllist(struct map_session_data *sd,int n,unsigned short *item_list)
{
	int i,z;

	if(npc_checknear(sd,sd->npc_id))
		return 1;
	for(i=0,z=0;i<n;i++){
		int nameid;
		if(item_list[i*2]-2 <0 || item_list[i*2]-2 >=MAX_INVENTORY)
			return 1;
		nameid=sd->status.inventory[item_list[i*2]-2].nameid;
		if(nameid == 0 ||
		   sd->status.inventory[item_list[i*2]-2].amount < item_list[i*2+1])
			return 1;
		z+=pc_modifysellvalue(sd,itemdb_sellvalue(nameid)) * item_list[i*2+1];
	}

	pc_getzeny(sd,z);
	for(i=0;i<n;i++){
		pc_delitem(sd,item_list[i*2]-2,item_list[i*2+1]);
	}
	return 0;
}

//
// ط
//

/*==========================================
 *
 *------------------------------------------
 */
// ɤ߹npcե
void npc_addsrcfile(char *name)
{
	struct npc_src_list *new;

	new=malloc(sizeof(*new)+strlen(name));
	if(new==NULL){
		printf("out of memory : npc_addsrcfile\n");
		exit(1);
	}
	new->next = NULL;
	strcpy(new->name,name);
	if(npc_src_first==NULL)
		npc_src_first = new;
	if(npc_src_last)
		npc_src_last->next = new;

	npc_src_last=new;
}

/*==========================================
 *
 *------------------------------------------
 */
// warpɤ߹
#define WARP_CLASS 45
static int npc_parse_warp(char *w1,char *w2,char *w3,char *w4)
{
	int x,y,xs,ys,to_x,to_y,m;
	int i,j;
	char mapname[24],to_mapname[24];
	struct npc_data *nd;

	// θĿå
	if(sscanf(w1,"%[^,],%d,%d",mapname,&x,&y) != 3 ||
	   sscanf(w4,"%d,%d,%[^,],%d,%d",&xs,&ys,to_mapname,&to_x,&to_y) != 5){
		printf("bad warp line : %s\n",w3);
		return 1;
	}

	m=map_mapname2mapid(mapname);

	nd=malloc(sizeof(struct npc_data));
	if(nd==NULL){
		printf("out of memory : npc_parse_warp\n");
		exit(1);
	}
	nd->bl.id=npc_id++;
	nd->n=map_addnpc(m,nd);

	nd->bl.m=m;
	nd->bl.x=x;
	nd->bl.y=y;
	nd->dir=0;
	memcpy(nd->name,w3,24);

	nd->class=WARP_CLASS;
	memcpy(nd->u.warp.name,to_mapname,16);
	xs+=2; ys+=2;
	nd->u.warp.x=to_x;
	nd->u.warp.y=to_y;
	nd->u.warp.xs=xs;
	nd->u.warp.ys=ys;

	for(i=0;i<ys;i++){
		for(j=0;j<xs;j++){
			int t;
			t=map_getcell(m,x-xs/2+j,y-ys/2+i);
			if(t==1 || t==5)
				continue;
			map_setcell(m,x-xs/2+j,y-ys/2+i,t|0x80);
		}
	}

	//printf("warp npc %s %d read done\n",mapname,nd->bl.id);
	npc_warp++;
	nd->bl.type=BL_NPC;
	nd->bl.subtype=WARP;
	map_addblock(&nd->bl);
	clif_spawnnpc(nd);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
// shopɤ߹
static int npc_parse_shop(char *w1,char *w2,char *w3,char *w4)
{
	char *p;
	int x,y,dir,m;
	int max=64,pos=0;
	char mapname[24];
	struct npc_data *nd;

	// θĿå
	if(sscanf(w1,"%[^,],%d,%d,%d",mapname,&x,&y,&dir) != 4 ||
	   strchr(w4,',')==NULL){
		printf("bad shop line : %s\n",w3);
		return 1;
	}
	m = map_mapname2mapid(mapname);

	nd=malloc(sizeof(struct npc_data)+sizeof(nd->u.shop_item[0])*(max+1));
	if(nd==NULL){
		printf("out of memory : npc_parse_shop\n");
		exit(1);
	}
	p=strchr(w4,',');

	while(p && pos<max){
		int nameid,value;
		p++;
		if(sscanf(p,"%d:%d",&nameid,&value)!=2)
			break;
		nd->u.shop_item[pos].nameid=nameid;
		nd->u.shop_item[pos].value=value;
		pos++;
		p=strchr(p,',');
	}
	if(pos==0){
		free(nd);
		return 1;
	}
	nd->u.shop_item[pos++].nameid=0;

	nd->bl.m = m;
	nd->bl.x = x;
	nd->bl.y = y;
	nd->bl.id=npc_id++;
	nd->dir = dir;
	memcpy(nd->name,w3,24);
	nd->class=atoi(w4);

	nd=realloc(nd,sizeof(struct npc_data)+sizeof(nd->u.shop_item[0])*pos);
	if(nd==NULL){
		printf("out of memory : npc_parse_shop realloc\n");
		exit(1);
	}

	//printf("shop npc %s %d read done\n",mapname,nd->bl.id);
	npc_shop++;
	nd->bl.type=BL_NPC;
	nd->bl.subtype=SHOP;
	nd->n=map_addnpc(m,nd);
	map_addblock(&nd->bl);
	clif_spawnnpc(nd);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
// scriptɤ߹
static int npc_parse_script(char *w1,char *w2,char *w3,char *w4,char *first_line,FILE *fp,int *lines)
{
	int x,y,dir,m,xs,ys,class;
	char mapname[24];
	char *srcbuf,*script;
	int srcsize=65536;
	int startline=0;
	char line[1024];
	int i;
	struct npc_data *nd;

	// θĿå
	if(sscanf(w1,"%[^,],%d,%d,%d",mapname,&x,&y,&dir) != 4 ||
	   strchr(w4,',')==NULL){
		printf("bad script line : %s\n",w3);
		return 1;
	}
	m = map_mapname2mapid(mapname);

	srcbuf=malloc(srcsize);
	if(srcbuf==NULL){
		printf("out of memory : npc_parse_script srcbuf\n");
		exit(1);
	}
	if(strchr(first_line,'{')){
		strcpy(srcbuf,strchr(first_line,'{'));
		startline=*lines;
	} else
		srcbuf[0]=0;
	while(1){
		for(i=strlen(srcbuf)-1;i>=0 && isspace(srcbuf[i]);i--);
		if(i>=0 && srcbuf[i]=='}')
			break;
		fgets(line,1020,fp);
		(*lines)++;
		if(feof(fp))
			break;
		if(strlen(srcbuf)+strlen(line)+1>=srcsize){
			srcsize+=65536;
			srcbuf=realloc(srcbuf,srcsize);
			if(srcbuf==NULL){
				printf("out of memory : npc_parse_script srcbuf realloc\n");
				exit(1);
			}
		}
		if(srcbuf[0]!='{'){
			if(strchr(line,'{')){
				strcpy(srcbuf,strchr(line,'{'));
				startline=*lines;
			}
		} else
			strcat(srcbuf,line);
	}
	script=parse_script(srcbuf,startline);
	free(srcbuf);
	if(script==NULL){
		// script parse error?
		return 1;
	}

	nd=malloc(sizeof(struct npc_data));
	if(nd==NULL){
		printf("out of memory : npc_parse_script nd\n");
		exit(1);
	}

	if(sscanf(w4,"%d,%d,%d",&class,&xs,&ys)==3){
		int i,j;

		xs+=2;
		ys+=2;
		for(i=0;i<ys;i++){
			for(j=0;j<xs;j++){
				int t;
				t=map_getcell(m,x-xs/2+j,y-ys/2+i);
				if(t==1 || t==5)
					continue;
				map_setcell(m,x-xs/2+j,y-ys/2+i,t|0x80);
			}
		}

		nd->u.scr.xs=xs;
		nd->u.scr.ys=ys;
	} else {
		class=atoi(w4);
		nd->u.scr.xs=0;
		nd->u.scr.ys=0;
	}

	nd->bl.m = m;
	nd->bl.x = x;
	nd->bl.y = y;
	nd->bl.id=npc_id++;
	nd->dir = dir;
	memcpy(nd->name,w3,24);
	nd->class=class;
	nd->u.scr.script=script;

	//printf("script npc %s %d %d read done\n",mapname,nd->bl.id,nd->class);
	npc_script++;
	nd->bl.type=BL_NPC;
	nd->bl.subtype=SCRIPT;
	nd->n=map_addnpc(m,nd);
	map_addblock(&nd->bl);
	clif_spawnnpc(nd);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
int npc_parse_mob(char *w1,char *w2,char *w3,char *w4)
{
	int m,x,y,xs,ys,class,num,delay1,delay2;
	int i;
	char mapname[24];
	struct mob_data *md,*base;

	xs=ys=0;
	delay1=delay2=0;
	// θĿå
	if(sscanf(w1,"%[^,],%d,%d,%d,%d",mapname,&x,&y,&xs,&ys) < 3 ||
	   sscanf(w4,"%d,%d,%d,%d",&class,&num,&delay1,&delay2) < 2 ){
		printf("bad monster line : %s\n",w3);
		return 1;
	}

	m=map_mapname2mapid(mapname);

	base=malloc(sizeof(struct mob_data)*num);
	if(base==NULL){
		printf("out of memory : npc_parse_mob\n");
		exit(1);
	}
	for(i=0;i<num;i++){
		md=&base[i];

		md->bl.prev=NULL;
		md->bl.next=NULL;
		md->bl.m=m;
		md->bl.x=x;
		md->bl.y=y;
		memcpy(md->name,w3,24);

		md->n = i;
		md->class=class;
		md->bl.id=npc_id++;
		md->x0=x;
		md->y0=y;
		md->xs=xs;
		md->ys=ys;
		md->spawndelay1=delay1;
		md->spawndelay2=delay2;

		md->state=0;
		md->timer=0;
		md->target_id=0;
		md->attacked_id=0;
		md->speed=200;

		md->bl.type=BL_MOB;
		map_addiddb(&md->bl);
		mob_spawn(md->bl.id);

		npc_mob++;
	}
	//printf("warp npc %s %d read done\n",mapname,nd->bl.id);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
// npc
int do_init_npc(void)
{
	struct npc_src_list *nsl;
	FILE *fp;
	char line[1024];
	int m,lines;

	for(nsl=npc_src_first;nsl;nsl=nsl->next){
		fp=fopen(nsl->name,"r");
		if(fp==NULL){
			printf("file not found : %s\n",nsl->name);
			exit(1);
		}
		lines=0;
		while(fgets(line,1020,fp)){
			char w1[1024],w2[1024],w3[1024],w4[1024],mapname[1024];
			int i,j,w4pos;
			// פʥڡ䥿֤Ϣ³ϵͤ
			lines++;
			for(i=j=0;line[i];i++){
				if(line[i]==' '){
					if(!((line[i+1] && (isspace(line[i+1]) || line[i+1]==',')) ||
						 (j && line[j-1]==',')))
						line[j++]=' ';
				} else if(line[i]=='\t'){
					if(!(j && line[j-1]=='\t'))
						line[j++]='\t';
				} else
 					line[j++]=line[i];
			}
			// ǽϥֶڤǥåƤߤơʤ饹ڡڤǳǧ
			if(sscanf(line,"%[^\t]\t%[^\t]\t%[^\t]\t%n%[^\t\r\n]",w1,w2,w3,&w4pos,w4)!=4 &&
			   sscanf(line,"%s%s%s%n%s",w1,w2,w3,&w4pos,w4)!=4){
				continue;
			}
			sscanf(w1,"%[^,]",mapname);
			m = map_mapname2mapid(mapname);
			if(strlen(mapname)>16 || m<0){
				// "mapname" is not assigned to this server
				continue;
			}
			if(strcmp(w2,"warp")==0){
				npc_parse_warp(w1,w2,w3,w4);
			} else if(strcmp(w2,"shop")==0){
				npc_parse_shop(w1,w2,w3,w4);
			} else if(strcmp(w2,"script")==0){
				npc_parse_script(w1,w2,w3,w4,line+w4pos,fp,&lines);
			} else if(strcmp(w2,"monster")==0){
				npc_parse_mob(w1,w2,w3,w4);
			}
		}
		fclose(fp);
		printf("read npc %s done\n",nsl->name);
	}
	printf("total %d npcs (%d warp, %d shop, %d script, %d mob)\n",
		   npc_id-50000,npc_warp,npc_shop,npc_script,npc_mob);

	//exit(1);

	return 0;
}
