#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "battle.h"

#include "timer.h"

#include "map.h"
#include "pc.h"
#include "skill.h"
#include "mob.h"
#include "itemdb.h"
#include "clif.h"
#include "pet.h"
#include "guild.h"

int attr_fix_table[4][10][10];

struct Battle_Config battle_config;

/*==========================================
 * _Ԃ̋Ԃ
 * ߂͐0ȏ
 *------------------------------------------
 */
static int distance(int x0,int y0,int x1,int y1)
{
	int dx,dy;

	dx=abs(x0-x1);
	dy=abs(y0-y1);
	return dx>dy ? dx : dy;
}

/*==========================================
 * bNĂΏۂ̐Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_counttargeted(struct block_list *bl,struct block_list *src,int target_lv)
{
	if( bl == NULL ){
		printf("battle_counttargeted nullpo\n");
		return 0;
	}
	if(bl->type == BL_PC)
		return pc_counttargeted((struct map_session_data *)bl,src,target_lv);
	else if(bl->type == BL_MOB)
		return mob_counttargeted((struct mob_data *)bl,src,target_lv);
	return 0;
}
/*==========================================
 * ΏۂClassԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_class(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_class nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return ((struct mob_data *)bl)->class;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->status.class;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return ((struct pet_data *)bl)->class;
	else
		return 0;
}
/*==========================================
 * Ώۂ̕Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_dir(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_dir nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return ((struct mob_data *)bl)->dir;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->dir;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return ((struct pet_data *)bl)->dir;
	else
		return 0;
}
/*==========================================
 * Ώۂ̃xԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_lv(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_lv nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].lv;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->status.base_level;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return ((struct pet_data *)bl)->msd->pet.level;
	else
		return 0;
}
/*==========================================
 * Ώۂ̎˒Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_range(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_range nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].range;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->attackrange;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return mob_db[((struct pet_data *)bl)->class].range;
	else
		return 0;
}
/*==========================================
 * ΏۂHPԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_hp(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_hp nullpo\n");
		return 1;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return ((struct mob_data *)bl)->hp;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->status.hp;
	else
		return 1;
}
/*==========================================
 * ΏۂMHPԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_max_hp(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_max_hp nullpo\n");
		return 1;
	}
	if(bl->type==BL_PC && ((struct map_session_data *)bl))
		return ((struct map_session_data *)bl)->status.max_hp;
	else {
		struct status_change *sc_data=battle_get_sc_data(bl);
		int max_hp=1;
		if(bl->type==BL_MOB && ((struct mob_data*)bl)) {
			max_hp = mob_db[((struct mob_data*)bl)->class].max_hp;
			if(mob_db[((struct mob_data*)bl)->class].mexp > 0) {
				if(battle_config.mvp_hp_rate != 100)
					max_hp = (max_hp * battle_config.mvp_hp_rate)/100;
			}
			else {
				if(battle_config.monster_hp_rate != 100)
					max_hp = (max_hp * battle_config.monster_hp_rate)/100;
			}
		}
		else if(bl->type==BL_PET && ((struct pet_data*)bl)) {
			max_hp = mob_db[((struct pet_data*)bl)->class].max_hp;
			if(mob_db[((struct pet_data*)bl)->class].mexp > 0) {
				if(battle_config.mvp_hp_rate != 100)
					max_hp = (max_hp * battle_config.mvp_hp_rate)/100;
			}
			else {
				if(battle_config.monster_hp_rate != 100)
					max_hp = (max_hp * battle_config.monster_hp_rate)/100;
			}
		}
		if(sc_data) {
			if(sc_data[SC_APPLEIDUN].timer!=-1)
				max_hp += ((5+sc_data[SC_APPLEIDUN].val1*2+((sc_data[SC_APPLEIDUN].val2+1)>>1)
						+sc_data[SC_APPLEIDUN].val3/10) * max_hp)/100;
		}
		if(max_hp < 1) max_hp = 1;
		return max_hp;
	}
	return 1;
}
/*==========================================
 * ΏۂStrԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_str(struct block_list *bl)
{
	int str=0;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_str nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_MOB && ((struct mob_data *)bl))
		str = mob_db[((struct mob_data *)bl)->class].str;
	else if(bl->type==BL_PC && ((struct map_session_data *)bl))
		return ((struct map_session_data *)bl)->paramc[0];
	else if(bl->type==BL_PET && ((struct pet_data *)bl))
		str = mob_db[((struct pet_data *)bl)->class].str;

	if(sc_data) {
		if(sc_data[SC_LOUD].timer!=-1 && sc_data[SC_QUAGMIRE].timer == -1 && bl->type != BL_PC)
			str += 4;
		if( sc_data[SC_BLESSING].timer != -1 && bl->type != BL_PC){	// ubVO
			int race=battle_get_race(bl);
			if(battle_check_undead(race,battle_get_elem_type(bl)) || race==6 )	str >>= 1;	//  /s
			else str += sc_data[SC_BLESSING].val1;	// ̑
		}
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)	// gD[TCg
			str += 5;
	}
	if(str < 0) str = 0;
	return str;
}
/*==========================================
 * ΏۂAgiԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */

int battle_get_agi(struct block_list *bl)
{
	int agi=0;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_agi nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		agi=mob_db[((struct mob_data *)bl)->class].agi;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		agi=((struct map_session_data *)bl)->paramc[1];
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		agi=mob_db[((struct pet_data *)bl)->class].agi;

	if(sc_data) {
		if( sc_data[SC_INCREASEAGI].timer!=-1 && sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1 &&
			bl->type != BL_PC)	// x(PCpc.c)
			agi += 2+sc_data[SC_INCREASEAGI].val1;

		if(sc_data[SC_CONCENTRATE].timer!=-1 && sc_data[SC_QUAGMIRE].timer == -1 && bl->type != BL_PC)
			agi += agi*(2+sc_data[SC_CONCENTRATE].val1)/100;

		if(sc_data[SC_DECREASEAGI].timer!=-1)	// x
			agi -= 2+sc_data[SC_DECREASEAGI].val1;

		if(sc_data[SC_QUAGMIRE].timer!=-1 )	// N@O}CA
			agi >>= 1;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)	// gD[TCg
			agi += 5;
	}
	if(agi < 0) agi = 0;
	return agi;
}
/*==========================================
 * ΏۂVitԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_vit(struct block_list *bl)
{
	int vit=0;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_vit nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		vit=mob_db[((struct mob_data *)bl)->class].vit;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		vit=((struct map_session_data *)bl)->paramc[2];
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		vit=mob_db[((struct pet_data *)bl)->class].vit;
	if(sc_data) {
		if(sc_data[SC_STRIPARMOR].timer != -1 && bl->type!=BL_PC)
			vit = vit*60/100;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)	// gD[TCg
			vit += 5;
	}

	if(vit < 0) vit = 0;
	return vit;
}
/*==========================================
 * ΏۂIntԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_int(struct block_list *bl)
{
	int int_=0;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_int nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		int_=mob_db[((struct mob_data *)bl)->class].int_;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		int_=((struct map_session_data *)bl)->paramc[3];
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		int_=mob_db[((struct pet_data *)bl)->class].int_;

	if(sc_data) {
		if( sc_data[SC_BLESSING].timer != -1 && bl->type != BL_PC){	// ubVO
			int race=battle_get_race(bl);
			if(battle_check_undead(race,battle_get_elem_type(bl)) || race==6 )	int_ >>= 1;	//  /s
			else int_ += sc_data[SC_BLESSING].val1;	// ̑
		}
		if( sc_data[SC_STRIPHELM].timer != -1 && bl->type != BL_PC)
			int_ = int_*90/100;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)	// gD[TCg
			int_ += 5;
	}
	if(int_ < 0) int_ = 0;
	return int_;
}
/*==========================================
 * ΏۂDexԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_dex(struct block_list *bl)
{
	int dex=0;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_dex nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		dex=mob_db[((struct mob_data *)bl)->class].dex;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		dex=((struct map_session_data *)bl)->paramc[4];
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		dex=mob_db[((struct pet_data *)bl)->class].dex;

	if(sc_data) {
		if(sc_data[SC_CONCENTRATE].timer!=-1 && sc_data[SC_QUAGMIRE].timer == -1 && bl->type != BL_PC)
			dex += dex*(2+sc_data[SC_CONCENTRATE].val1)/100;

		if( sc_data[SC_BLESSING].timer != -1 && bl->type != BL_PC){	// ubVO
			int race=battle_get_race(bl);
			if(battle_check_undead(race,battle_get_elem_type(bl)) || race==6 )	dex >>= 1;	//  /s
			else dex += sc_data[SC_BLESSING].val1;	// ̑
		}

		if(sc_data[SC_QUAGMIRE].timer!=-1 )	// N@O}CA
			dex >>= 1;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)	// gD[TCg
			dex += 5;
	}
	if(dex < 0) dex = 0;
	return dex;
}
/*==========================================
 * ΏۂLukԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_luk(struct block_list *bl)
{
	int luk=0;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_luk nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		luk=mob_db[((struct mob_data *)bl)->class].luk;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		luk=((struct map_session_data *)bl)->paramc[5];
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		luk=mob_db[((struct pet_data *)bl)->class].luk;

	if(sc_data) {
		if(sc_data[SC_GLORIA].timer!=-1 && bl->type != BL_PC)	// OA(PCpc.c)
			luk += 30;
		if(sc_data[SC_CURSE].timer!=-1 )		// 
			luk=0;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)	// gD[TCg
			luk += 5;
	}
	if(luk < 0) luk = 0;
	return luk;
}

/*==========================================
 * ΏۂFleeԂ(ėp)
 * ߂͐1ȏ
 *------------------------------------------
 */
int battle_get_flee(struct block_list *bl)
{
	int flee=1;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_flee nullpo\n");
		return 1;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		flee=((struct map_session_data *)bl)->flee;
	else
		flee=battle_get_agi(bl) + battle_get_lv(bl);

	if(sc_data) {
		if(sc_data[SC_WHISTLE].timer!=-1 && bl->type != BL_PC)
			flee += flee*(sc_data[SC_WHISTLE].val1+sc_data[SC_WHISTLE].val2
					+(sc_data[SC_WHISTLE].val3>>16))/100;
		if(sc_data[SC_BLIND].timer!=-1 && bl->type != BL_PC)
			flee -= flee*25/100;
		if(sc_data[SC_WINDWALK].timer!=-1 && bl->type != BL_PC) // EBhEH[N
			flee += flee*(sc_data[SC_WINDWALK].val2)/100;
		if(sc_data[SC_SPIDERWEB].timer!=-1 && bl->type != BL_PC) //XpC_[EFu
			flee -= flee*50/100;
	}
	if(flee < 1) flee = 1;
	return flee;
}
/*==========================================
 * ΏۂHitԂ(ėp)
 * ߂͐1ȏ
 *------------------------------------------
 */
int battle_get_hit(struct block_list *bl)
{
	int hit=1;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_hit nullpo\n");
		return 1;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		hit=((struct map_session_data *)bl)->hit;
	else
		hit=battle_get_dex(bl) + battle_get_lv(bl);

	if(sc_data) {
		if(sc_data[SC_HUMMING].timer!=-1 && bl->type != BL_PC)	// 
			hit += hit*(sc_data[SC_HUMMING].val1*2+sc_data[SC_HUMMING].val2
					+sc_data[SC_HUMMING].val3)/100;
		if(sc_data[SC_BLIND].timer!=-1 && bl->type != BL_PC)		// 
			hit -= hit*25/100;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC)		// gD[TCg
			hit += 3*(sc_data[SC_TRUESIGHT].val1);
		if(sc_data[SC_CONCENTRATION].timer!=-1 && bl->type != BL_PC) //RZg[V
			hit += (hit*(10*(sc_data[SC_CONCENTRATION].val1)))/100;
	}
	if(hit < 1) hit = 1;
	return hit;
}
/*==========================================
 * Ώۂ̊SԂ(ėp)
 * ߂͐1ȏ
 *------------------------------------------
 */
int battle_get_flee2(struct block_list *bl)
{
	int flee2=1;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_flee2 nullpo\n");
		return 1;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl){
		flee2 = battle_get_luk(bl) + 10;
		flee2 += ((struct map_session_data *)bl)->flee2 - (((struct map_session_data *)bl)->paramc[5] + 10);
	}
	else
		flee2=battle_get_luk(bl)+1;

	if(sc_data) {
		if(sc_data[SC_WHISTLE].timer!=-1 && bl->type != BL_PC)
			flee2 += (sc_data[SC_WHISTLE].val1+sc_data[SC_WHISTLE].val2
					+(sc_data[SC_WHISTLE].val3&0xffff))*10;
	}
	if(flee2 < 1) flee2 = 1;
	return flee2;
}
/*==========================================
 * Ώۂ̃NeBJԂ(ėp)
 * ߂͐1ȏ
 *------------------------------------------
 */
int battle_get_critical(struct block_list *bl)
{
	int critical=1;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_critical nullpo\n");
		return 1;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl){
		critical = battle_get_luk(bl)*3 + 10;
		critical += ((struct map_session_data *)bl)->critical - ((((struct map_session_data *)bl)->paramc[5]*3) + 10);
	}
	else
		critical=battle_get_luk(bl)*3 + 1;

	if(sc_data) {
		if(sc_data[SC_FORTUNE].timer!=-1 && bl->type != BL_PC)
			critical += (10+sc_data[SC_FORTUNE].val1+sc_data[SC_FORTUNE].val2
					+sc_data[SC_FORTUNE].val3)*10;
		if(sc_data[SC_EXPLOSIONSPIRITS].timer!=-1 && bl->type != BL_PC)
			critical += sc_data[SC_EXPLOSIONSPIRITS].val2;
		if(sc_data[SC_TRUESIGHT].timer!=-1 && bl->type != BL_PC) //gD[TCg
			critical += critical*sc_data[SC_TRUESIGHT].val1/100;
	}
	if(critical < 1) critical = 1;
	return critical;
}
/*==========================================
 * base_atk̎擾
 * ߂͐1ȏ
 *------------------------------------------
 */
int battle_get_baseatk(struct block_list *bl)
{
	struct status_change *sc_data;
	int batk=1;

	if( bl == NULL ){
		printf("battle_get_baseatk nullpo\n");
		return 1;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		batk = ((struct map_session_data *)bl)->base_atk; //ݒ肳Ăbase_atk
	else { //ȊOȂ
		int str,dstr;
		str = battle_get_str(bl); //STR
		dstr = str/10;
		batk = dstr*dstr + str; //base_atkvZ
	}
	if(sc_data) { //Ԉُ킠
		if(sc_data[SC_PROVOKE].timer!=-1 && bl->type != BL_PC) //PCŃv{bN(SM_PROVOKE)
			batk = batk*(100+2*sc_data[SC_PROVOKE].val1)/100; //base_atk
		if(sc_data[SC_CURSE].timer!=-1 ) //Ă
			batk -= batk*25/100; //base_atk25%
		if(sc_data[SC_CONCENTRATION].timer!=-1 && bl->type != BL_PC) //RZg[V
			batk += batk*(5*sc_data[SC_CONCENTRATION].val1)/100;
	}
	if(batk < 1) batk = 1; //base_atk͍Œł1
	return batk;
}
/*==========================================
 * ΏۂAtkԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_atk(struct block_list *bl)
{
	struct status_change *sc_data;
	int atk=0;

	if( bl == NULL ){
		printf("battle_get_atk nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		atk = ((struct map_session_data*)bl)->watk;
	else if(bl->type==BL_MOB && (struct mob_data *)bl)
		atk = mob_db[((struct mob_data*)bl)->class].atk1;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		atk = mob_db[((struct pet_data*)bl)->class].atk1;

	if(sc_data) {
		if(sc_data[SC_PROVOKE].timer!=-1 && bl->type != BL_PC)
			atk = atk*(100+2*sc_data[SC_PROVOKE].val1)/100;
		if(sc_data[SC_CURSE].timer!=-1 )
			atk -= atk*25/100;
		if(sc_data[SC_CONCENTRATION].timer!=-1 && bl->type != BL_PC) //RZg[V
			atk += atk*(5*sc_data[SC_CONCENTRATION].val1)/100;
	}
	if(atk < 0) atk = 0;
	return atk;
}
/*==========================================
 * Ώۂ̍AtkԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_atk_(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_atk_ nullpo\n");
		return 0;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl){
		int atk=((struct map_session_data*)bl)->watk_;

		if(((struct map_session_data *)bl)->sc_data[SC_CURSE].timer!=-1 )
			atk -= atk*25/100;
		return atk;
	}
	else
		return 0;
}
/*==========================================
 * ΏۂAtk2Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_atk2(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_atk2 nullpo\n");
		return 0;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data*)bl)->watk2;
	else {
		struct status_change *sc_data=battle_get_sc_data(bl);
		int atk2=0;
		if(bl->type==BL_MOB && (struct mob_data *)bl)
			atk2 = mob_db[((struct mob_data*)bl)->class].atk2;
		else if(bl->type==BL_PET && (struct pet_data *)bl)
			atk2 = mob_db[((struct pet_data*)bl)->class].atk2;
		if(sc_data) {
			if( sc_data[SC_IMPOSITIO].timer!=-1)
				atk2 += sc_data[SC_IMPOSITIO].val1*5;
			if( sc_data[SC_PROVOKE].timer!=-1 )
				atk2 = atk2*(100+2*sc_data[SC_PROVOKE].val1)/100;
			if( sc_data[SC_CURSE].timer!=-1 )
				atk2 -= atk2*25/100;
			if(sc_data[SC_DRUMBATTLE].timer!=-1)
				atk2 += sc_data[SC_DRUMBATTLE].val2;
			if(sc_data[SC_NIBELUNGEN].timer!=-1 && (battle_get_element(bl)/10) >= 8 )
				atk2 += sc_data[SC_NIBELUNGEN].val2;
			if(sc_data[SC_STRIPWEAPON].timer!=-1)
				atk2 -= atk2*90/100;
			if(sc_data[SC_CONCENTRATION].timer!=-1) //RZg[V
				atk2 += atk2*(5*sc_data[SC_CONCENTRATION].val1)/100;
		}
		if(atk2 < 0) atk2 = 0;
		return atk2;
	}
	return 0;
}
/*==========================================
 * Ώۂ̍Atk2Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_atk_2(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_atk_2 nullpo\n");
		return 0;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data*)bl)->watk_2;
	else
		return 0;
}
/*==========================================
 * ΏۂMAtk1Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_matk1(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_matk1 nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB){
		int matk,int_=battle_get_int(bl);
		matk = int_+(int_/5)*(int_/5);
		return matk;
	}
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->matk1;
	else if(bl->type==BL_PET){
		int matk,int_=battle_get_int(bl);
		matk = int_+(int_/5)*(int_/5);
		return matk;
	}
	else
		return 0;
}
/*==========================================
 * ΏۂMAtk2Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_matk2(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_matk2 nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB){
		int matk,int_=battle_get_int(bl);
		matk = int_+(int_/7)*(int_/7);
		return matk;
	}
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->matk2;
	else if(bl->type==BL_PET){
		int matk,int_=battle_get_int(bl);
		matk = int_+(int_/7)*(int_/7);
		return matk;
	}
	else
		return 0;
}
/*==========================================
 * ΏۂDefԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_def(struct block_list *bl)
{
	struct status_change *sc_data;
	int def=0,skilltimer=-1,skillid=0;

	if( bl == NULL ){
		printf("battle_get_def nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl){
		def = ((struct map_session_data *)bl)->def;
		skilltimer = ((struct map_session_data *)bl)->skilltimer;
		skillid = ((struct map_session_data *)bl)->skillid;
	}
	else if(bl->type==BL_MOB && (struct mob_data *)bl) {
		def = mob_db[((struct mob_data *)bl)->class].def;
		skilltimer = ((struct mob_data *)bl)->skilltimer;
		skillid = ((struct mob_data *)bl)->skillid;
	}
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		def = mob_db[((struct pet_data *)bl)->class].def;

	if(def < 1000000) {
		if(sc_data) {
			//L[sODEF100
			if( sc_data[SC_KEEPING].timer!=-1)
				def = 100;
			//v{bN͌Z
			if( sc_data[SC_PROVOKE].timer!=-1 && bl->type != BL_PC)
				def = (def*(100 - 6*sc_data[SC_PROVOKE].val1)+50)/100;
			//푾ۂ͉̋Z
			if( sc_data[SC_DRUMBATTLE].timer!=-1 && bl->type != BL_PC)
				def += sc_data[SC_DRUMBATTLE].val3;
			//łɂĂ鎞͌Z
			if(sc_data[SC_POISON].timer!=-1 && bl->type != BL_PC)
				def = def*75/100;
			//XgbvV[h͌Z
			if(sc_data[SC_STRIPSHIELD].timer!=-1 && bl->type != BL_PC)
				def = def*85/100;
			//VOiNVX͌Z
			if(sc_data[SC_SIGNUMCRUCIS].timer!=-1 && bl->type != BL_PC)
				def = def * (100 - sc_data[SC_SIGNUMCRUCIS].val2)/100;
			//i̍׎DEF0ɂȂ
			if(sc_data[SC_ETERNALCHAOS].timer!=-1 && bl->type != BL_PC)
				def = 0;
			//AΉ͉EVtg
			if(sc_data[SC_FREEZE].timer != -1 || (sc_data[SC_STONE].timer != -1 && sc_data[SC_STONE].val2 == 0))
				def >>= 1;
			//RZg[V͌Z
			if( sc_data[SC_CONCENTRATION].timer!=-1 && bl->type != BL_PC)
				def = (def*(100 - 5*sc_data[SC_CONCENTRATION].val1))/100;
		}
		//r͉rZɊÂČZ
		if(skilltimer != -1) {
			int def_rate = skill_get_castdef(skillid);
			if(def_rate != 0)
				def = (def * (100 - def_rate))/100;
		}
	}
	if(def < 0) def = 0;
	return def;
}
/*==========================================
 * ΏۂMDefԂ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_mdef(struct block_list *bl)
{
	struct status_change *sc_data;
	int mdef=0;

	if( bl == NULL ){
		printf("battle_get_mdef nullpo\n");
		return 0;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		mdef = ((struct map_session_data *)bl)->mdef;
	else if(bl->type==BL_MOB && (struct mob_data *)bl)
		mdef = mob_db[((struct mob_data *)bl)->class].mdef;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		mdef = mob_db[((struct pet_data *)bl)->class].mdef;

	if(mdef < 1000000) {
		if(sc_data) {
			//oA[ԎMDEF100
			if(sc_data[SC_BARRIER].timer != -1)
				mdef = 100;
			//AΉ1.25{
			if(sc_data[SC_FREEZE].timer != -1 || (sc_data[SC_STONE].timer != -1 && sc_data[SC_STONE].val2 == 0))
				mdef = mdef*125/100;
		}
	}
	if(mdef < 0) mdef = 0;
	return mdef;
}
/*==========================================
 * ΏۂDef2Ԃ(ėp)
 * ߂͐1ȏ
 *------------------------------------------
 */
int battle_get_def2(struct block_list *bl)
{
	struct status_change *sc_data;
	int def2=1;

	if( bl == NULL ){
		printf("battle_get_def2 nullpo\n");
		return 1;
	}
	sc_data=battle_get_sc_data(bl);
	if(bl->type==BL_PC)
		def2 = ((struct map_session_data *)bl)->def2;
	else if(bl->type==BL_MOB)
		def2 = mob_db[((struct mob_data *)bl)->class].vit;
	else if(bl->type==BL_PET)
		def2 = mob_db[((struct pet_data *)bl)->class].vit;

	if(sc_data) {
		if( sc_data[SC_ANGELUS].timer!=-1 && bl->type != BL_PC)
			def2 = def2*(110+5*sc_data[SC_ANGELUS].val1)/100;
		if( sc_data[SC_PROVOKE].timer!=-1 && bl->type != BL_PC)
			def2 = (def2*(100 - 6*sc_data[SC_PROVOKE].val1)+50)/100;
		if(sc_data[SC_POISON].timer!=-1 && bl->type != BL_PC)
			def2 = def2*75/100;
		//RZg[V͌Z
		if( sc_data[SC_CONCENTRATION].timer!=-1 && bl->type != BL_PC)
			def2 = def2*(100 - 5*sc_data[SC_CONCENTRATION].val1)/100;
	}
	if(def2 < 1) def2 = 1;
	return def2;
}
/*==========================================
 * ΏۂMDef2Ԃ(ėp)
 * ߂͐0ȏ
 *------------------------------------------
 */
int battle_get_mdef2(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_mdef2 nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].int_ + (mob_db[((struct mob_data *)bl)->class].vit>>1);
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->mdef2 + (((struct map_session_data *)bl)->paramc[2]>>1);
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return mob_db[((struct pet_data *)bl)->class].int_ + (mob_db[((struct pet_data *)bl)->class].vit>>1);
	else
		return 0;
}
/*==========================================
 * ΏۂSpeed(ړx)Ԃ(ėp)
 * ߂͐1ȏ
 * Speed͏قړx
 *------------------------------------------
 */
int battle_get_speed(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_speed nullpo\n");
		return 1000;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->speed;
	else {
		struct status_change *sc_data=battle_get_sc_data(bl);
		int speed = 1000;
		if(bl->type==BL_MOB && (struct mob_data *)bl)
//			speed = mob_db[((struct mob_data *)bl)->class].speed;
			speed = ((struct mob_data *)bl)->speed;
		else if(bl->type==BL_PET && (struct pet_data *)bl)
			speed = ((struct pet_data *)bl)->msd->petDB->speed;

		if(sc_data) {
			//x25%Z
			if(sc_data[SC_INCREASEAGI].timer!=-1 && sc_data[SC_DONTFORGETME].timer == -1)
				speed -= speed*25/100;
			//x25%Z
			if(sc_data[SC_DECREASEAGI].timer!=-1)
				speed = speed*125/100;
			//N@O}CA50%Z
			if(sc_data[SC_QUAGMIRE].timer!=-1)
				speed = speed*3/2;
			//YȂŁc͉Z
			if(sc_data[SC_DONTFORGETME].timer!=-1)
				speed = speed*(100+sc_data[SC_DONTFORGETME].val1*2 + sc_data[SC_DONTFORGETME].val2 + (sc_data[SC_DONTFORGETME].val3&0xffff))/100;
			//25%Z
			if(sc_data[SC_STEELBODY].timer!=-1)
				speed = speed*125/100;
			//fBtF_[͉Z
			if(sc_data[SC_DEFENDER].timer!=-1)
				speed = (speed * (155 - sc_data[SC_DEFENDER].val1*5)) / 100;
			//xԂ4{x
			if(sc_data[SC_DANCING].timer!=-1 )
				speed*=4;
			//􂢎450Z
			if(sc_data[SC_CURSE].timer!=-1)
				speed = speed + 450;
			//EBhEH[NLv*2%Z
			if(sc_data[SC_WINDWALK].timer!=-1)
				speed -= (speed*(sc_data[SC_WINDWALK].val1*2))/100;
		}
		if(speed < 1) speed = 1;
		return speed;
	}

	return 1000;
}
/*==========================================
 * ΏۂaDelay(UfBC)Ԃ(ėp)
 * aDelay͏قUx
 *------------------------------------------
 */
int battle_get_adelay(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_adelay nullpo\n");
		return 4000;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return (((struct map_session_data *)bl)->aspd<<1);
	else {
		struct status_change *sc_data=battle_get_sc_data(bl);
		int adelay=4000,aspd_rate = 100,i;
		if(bl->type==BL_MOB && (struct mob_data *)bl)
			adelay = mob_db[((struct mob_data *)bl)->class].adelay;
		else if(bl->type==BL_PET && (struct pet_data *)bl)
			adelay = mob_db[((struct pet_data *)bl)->class].adelay;

		if(sc_data) {
			//c[nhNCbPgpŃN@O}CAłYȂŁcłȂ3Z
			if(sc_data[SC_TWOHANDQUICKEN].timer != -1 && sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1)	// 2HQ
				aspd_rate -= 30;
			//AhibVgpŃc[nhNCbPłN@O}CAłYȂŁcłȂ
			if(sc_data[SC_ADRENALINE].timer != -1 && sc_data[SC_TWOHANDQUICKEN].timer == -1 &&
				sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1) {	// AhibV
				//gp҂ƃp[eBo[ŊioݒłȂ3Z
				if(sc_data[SC_ADRENALINE].val2 || !battle_config.party_skill_penaly)
					aspd_rate -= 30;
				//łȂ2.5Z
				else
					aspd_rate -= 25;
			}
			//XsANBbP͌Z
			if(sc_data[SC_SPEARSQUICKEN].timer != -1 && sc_data[SC_ADRENALINE].timer == -1 &&
				sc_data[SC_TWOHANDQUICKEN].timer == -1 && sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1)	// XsANBbP
				aspd_rate -= sc_data[SC_SPEARSQUICKEN].val2;
			//[̃ATVNX͌Z
			if(sc_data[SC_ASSNCROS].timer!=-1 && // [z̃ATVNX
				sc_data[SC_TWOHANDQUICKEN].timer==-1 && sc_data[SC_ADRENALINE].timer==-1 && sc_data[SC_SPEARSQUICKEN].timer==-1 &&
				sc_data[SC_DONTFORGETME].timer == -1)
				aspd_rate -= 5+sc_data[SC_ASSNCROS].val1+sc_data[SC_ASSNCROS].val2+sc_data[SC_ASSNCROS].val3;
			//YȂŁc͉Z
			if(sc_data[SC_DONTFORGETME].timer!=-1)		// YȂ
				aspd_rate += sc_data[SC_DONTFORGETME].val1*3 + sc_data[SC_DONTFORGETME].val2 + (sc_data[SC_DONTFORGETME].val3>>16);
			//25%Z
			if(sc_data[SC_STEELBODY].timer!=-1)	// 
				aspd_rate += 25;
			//|[Vgp͌Z
			if(	sc_data[i=SC_SPEEDPOTION2].timer!=-1 || sc_data[i=SC_SPEEDPOTION1].timer!=-1 || sc_data[i=SC_SPEEDPOTION0].timer!=-1)
				aspd_rate -= sc_data[i].val2;
			//fBtF_[͉Z
			if(sc_data[SC_DEFENDER].timer != -1)
				adelay += (1100 - sc_data[SC_DEFENDER].val1*100);
		}
		if(aspd_rate != 100)
			adelay = adelay*aspd_rate/100;
		if(adelay < battle_config.monster_max_aspd<<1) adelay = battle_config.monster_max_aspd<<1;
		return adelay;
	}
	return 4000;
}
int battle_get_amotion(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_amotion nullpo\n");
		return 2000;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->amotion;
	else {
		struct status_change *sc_data=battle_get_sc_data(bl);
		int amotion=2000,aspd_rate = 100,i;
		if(bl->type==BL_MOB && (struct mob_data *)bl)
			amotion = mob_db[((struct mob_data *)bl)->class].amotion;
		else if(bl->type==BL_PET && (struct pet_data *)bl)
			amotion = mob_db[((struct pet_data *)bl)->class].amotion;

		if(sc_data) {
			if(sc_data[SC_TWOHANDQUICKEN].timer != -1 && sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1)	// 2HQ
				aspd_rate -= 30;
			if(sc_data[SC_ADRENALINE].timer != -1 && sc_data[SC_TWOHANDQUICKEN].timer == -1 &&
				sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1) {	// AhibV
				if(sc_data[SC_ADRENALINE].val2 || !battle_config.party_skill_penaly)
					aspd_rate -= 30;
				else
					aspd_rate -= 25;
			}
			if(sc_data[SC_SPEARSQUICKEN].timer != -1 && sc_data[SC_ADRENALINE].timer == -1 &&
				sc_data[SC_TWOHANDQUICKEN].timer == -1 && sc_data[SC_QUAGMIRE].timer == -1 && sc_data[SC_DONTFORGETME].timer == -1)	// XsANBbP
				aspd_rate -= sc_data[SC_SPEARSQUICKEN].val2;
			if(sc_data[SC_ASSNCROS].timer!=-1 && // [z̃ATVNX
				sc_data[SC_TWOHANDQUICKEN].timer==-1 && sc_data[SC_ADRENALINE].timer==-1 && sc_data[SC_SPEARSQUICKEN].timer==-1 &&
				sc_data[SC_DONTFORGETME].timer == -1)
				aspd_rate -= 5+sc_data[SC_ASSNCROS].val1+sc_data[SC_ASSNCROS].val2+sc_data[SC_ASSNCROS].val3;
			if(sc_data[SC_DONTFORGETME].timer!=-1)		// YȂ
				aspd_rate += sc_data[SC_DONTFORGETME].val1*3 + sc_data[SC_DONTFORGETME].val2 + (sc_data[SC_DONTFORGETME].val3>>16);
			if(sc_data[SC_STEELBODY].timer!=-1)	// 
				aspd_rate += 25;
			if(	sc_data[i=SC_SPEEDPOTION2].timer!=-1 || sc_data[i=SC_SPEEDPOTION1].timer!=-1 || sc_data[i=SC_SPEEDPOTION0].timer!=-1)
				aspd_rate -= sc_data[i].val2;
			if(sc_data[SC_DEFENDER].timer != -1)
				amotion += (550 - sc_data[SC_DEFENDER].val1*50);
		}
		if(aspd_rate != 100)
			amotion = amotion*aspd_rate/100;
		if(amotion < battle_config.monster_max_aspd) amotion = battle_config.monster_max_aspd;
		return amotion;
	}
	return 2000;
}
int battle_get_dmotion(struct block_list *bl)
{
	int ret;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_dmotion nullpo\n");
		return 0;
	}
	sc_data = battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl){
		ret=mob_db[((struct mob_data *)bl)->class].dmotion;
		if(battle_config.monster_damage_delay_rate != 100)
			ret = ret*battle_config.monster_damage_delay_rate/100;
	}
	else if(bl->type==BL_PC && (struct map_session_data *)bl){
		ret=((struct map_session_data *)bl)->dmotion;
		if(battle_config.pc_damage_delay_rate != 100)
			ret = ret*battle_config.pc_damage_delay_rate/100;
	}
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		ret=mob_db[((struct pet_data *)bl)->class].dmotion;
	else
		return 2000;

	if((sc_data && sc_data[SC_ENDURE].timer!=-1) ||
		(bl->type == BL_PC && ((struct map_session_data *)bl)->special_state.infinite_endure))
		ret=0;

	return ret;
}
int battle_get_element(struct block_list *bl)
{
	int ret = 20;
	struct status_change *sc_data;

	if( bl == NULL ){
		printf("battle_get_element nullpo\n");
		return ret;
	}
	sc_data = battle_get_sc_data(bl);
	if(bl->type==BL_MOB && (struct mob_data *)bl)	// 10̈ʁLv*2AP̈ʁ
		ret=((struct mob_data *)bl)->def_ele;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		ret=20+((struct map_session_data *)bl)->def_ele;	// h䑮Lv1
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		ret = mob_db[((struct pet_data *)bl)->class].element;

	if(sc_data) {
		if( sc_data[SC_BENEDICTIO].timer!=-1 )	// ̍~
			ret=26;
		if( sc_data[SC_FREEZE].timer!=-1 )	// 
			ret=21;
		if( sc_data[SC_STONE].timer!=-1 && sc_data[SC_STONE].val2==0)
			ret=22;
	}

	return ret;
}
int battle_get_attack_element(struct block_list *bl)
{
	int ret = 0;
	struct status_change *sc_data=battle_get_sc_data(bl);

	if( bl == NULL ){
		printf("battle_get_attack_element nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		ret=0;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		ret=((struct map_session_data *)bl)->atk_ele;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		ret=0;

	if(sc_data) {
		if( sc_data[SC_FROSTWEAPON].timer!=-1)	// tXgEF|
			ret=1;
		if( sc_data[SC_SEISMICWEAPON].timer!=-1)	// TCY~bNEF|
			ret=2;
		if( sc_data[SC_FLAMELAUNCHER].timer!=-1)	// t[`[
			ret=3;
		if( sc_data[SC_LIGHTNINGLOADER].timer!=-1)	// CgjO[_[
			ret=4;
		if( sc_data[SC_ENCPOISON].timer!=-1)	// G`g|CY
			ret=5;
		if( sc_data[SC_ASPERSIO].timer!=-1)		// AXyVI
			ret=6;
	}

	return ret;
}
int battle_get_attack_element2(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_attack_element2 nullpo\n");
		return 0;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl) {
		int ret = ((struct map_session_data *)bl)->atk_ele_;
		struct status_change *sc_data = ((struct map_session_data *)bl)->sc_data;

		if(sc_data) {
			if( sc_data[SC_FROSTWEAPON].timer!=-1)	// tXgEF|
				ret=1;
			if( sc_data[SC_SEISMICWEAPON].timer!=-1)	// TCY~bNEF|
				ret=2;
			if( sc_data[SC_FLAMELAUNCHER].timer!=-1)	// t[`[
				ret=3;
			if( sc_data[SC_LIGHTNINGLOADER].timer!=-1)	// CgjO[_[
				ret=4;
			if( sc_data[SC_ENCPOISON].timer!=-1)	// G`g|CY
				ret=5;
			if( sc_data[SC_ASPERSIO].timer!=-1)		// AXyVI
				ret=6;
		}
		return ret;
	}
	return 0;
}
int battle_get_party_id(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_party_id nullpo\n");
		return 0;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->status.party_id;
	else if(bl->type==BL_MOB && (struct mob_data *)bl){
		struct mob_data *md=(struct mob_data *)bl;
		if( md->master_id>0 )
			return -md->master_id;
		return -md->bl.id;
	}
	else if(bl->type==BL_SKILL && (struct skill_unit *)bl)
		return ((struct skill_unit *)bl)->group->party_id;
	else
		return 0;
}
int battle_get_guild_id(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_guild_id nullpo\n");
		return 0;
	}
	if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data *)bl)->status.guild_id;
	else if(bl->type==BL_MOB && (struct mob_data *)bl)
		return ((struct mob_data *)bl)->class;
	else if(bl->type==BL_SKILL && (struct skill_unit *)bl)
		return ((struct skill_unit *)bl)->group->guild_id;
	else
		return 0;
}
int battle_get_race(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_race nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].race;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return 7;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return mob_db[((struct pet_data *)bl)->class].race;
	else
		return 0;
}
int battle_get_size(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_luk nullpo\n");
		return 1;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].size;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return 1;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return mob_db[((struct pet_data *)bl)->class].size;
	else
		return 1;
}
int battle_get_mode(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_mode nullpo\n");
		return 0x01;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].mode;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return mob_db[((struct pet_data *)bl)->class].mode;
	else
		return 0x01;	// Ƃ肠ƂƂ1
}

int battle_get_mexp(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_mexp nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return mob_db[((struct mob_data *)bl)->class].mexp;
	else if(bl->type==BL_PET && (struct pet_data *)bl)
		return mob_db[((struct pet_data *)bl)->class].mexp;
	else
		return 0;
}

// StatusChangen̏
struct status_change *battle_get_sc_data(struct block_list *bl)
{
	if( bl == NULL ){
		printf("status_change nullpo\n");
		return NULL;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return ((struct mob_data*)bl)->sc_data;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return ((struct map_session_data*)bl)->sc_data;
	return NULL;
}
short *battle_get_sc_count(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_sc_count nullpo\n");
		return NULL;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return &((struct mob_data*)bl)->sc_count;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return &((struct map_session_data*)bl)->sc_count;
	return NULL;
}
short *battle_get_opt1(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_opt1 nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return &((struct mob_data*)bl)->opt1;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return &((struct map_session_data*)bl)->opt1;
	return 0;
}
short *battle_get_opt2(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_opt2 nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return &((struct mob_data*)bl)->opt2;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return &((struct map_session_data*)bl)->opt2;
	return 0;
}
short *battle_get_option(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_get_opt1 nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB && (struct mob_data *)bl)
		return &((struct mob_data*)bl)->option;
	else if(bl->type==BL_PC && (struct map_session_data *)bl)
		return &((struct map_session_data*)bl)->status.option;
	return 0;
}

//-------------------------------------------------------------------

// _[W̒x
struct battle_delay_damage_ {
	struct block_list *src,*target;
	int damage;
	int flag;
};
int battle_delay_damage_sub(int tid,unsigned int tick,int id,int data)
{
	struct battle_delay_damage_ *dat=(struct battle_delay_damage_ *)data;
	if( dat && map_id2bl(id)==dat->src && dat->target->prev!=NULL)
		battle_damage(dat->src,dat->target,dat->damage,dat->flag);
	free(dat);
	return 0;
}
int battle_delay_damage(unsigned int tick,struct block_list *src,struct block_list *target,int damage,int flag)
{
	struct battle_delay_damage_ *dat =
		(struct battle_delay_damage_*)calloc(sizeof *dat, 1);

	if( src == NULL || target == NULL ){
		printf("battle_delay_damage nullpo\n");
		return 0;
	}

	if (dat == NULL) {
		printf("out of memory: battle_delay_damage\n");
		exit(1);
	}
	
	dat->src=src;
	dat->target=target;
	dat->damage=damage;
	dat->flag=flag;
	add_timer(tick,battle_delay_damage_sub,src->id,(int)dat);
	return 0;
}

// ۂHP𑀍
int battle_damage(struct block_list *bl,struct block_list *target,int damage,int flag)
{
	struct map_session_data *sd=NULL;
	struct status_change *sc_data=battle_get_sc_data(target);
	short *sc_count;
	int i;

	if( target == NULL ){ //blNULLŌĂ΂邱Ƃ̂őŃ`FbN
		printf("battle_damage nullpo\n");
		return 0;
	}

	if(damage==0 || target->type == BL_PET)
		return 0;

	if(target->prev == NULL)
		return 0;

	if(bl) {
		if(bl->prev==NULL)
			return 0;

		if(bl->type==BL_PC)
			sd=(struct map_session_data *)bl;
	}
		
	if(damage<0)
		return battle_heal(bl,target,-damage,0,flag);

	if(!flag && (sc_count=battle_get_sc_count(target))!=NULL && *sc_count>0){
		// AΉA
		if(sc_data[SC_FREEZE].timer!=-1)
			skill_status_change_end(target,SC_FREEZE,-1);
		if(sc_data[SC_STONE].timer!=-1 && sc_data[SC_STONE].val2==0)
			skill_status_change_end(target,SC_STONE,-1);
		if(sc_data[SC_SLEEP].timer!=-1)
			skill_status_change_end(target,SC_SLEEP,-1);
	}

	if(target->type==BL_MOB){	// MOB
		struct mob_data *md=(struct mob_data *)target;
		if(md && md->skilltimer!=-1 && md->state.skillcastcancel)	// rWQ
			skill_castcancel(target,0);
		return mob_damage(bl,md,damage,0);
	}
	else if(target->type==BL_PC){	// PC

		struct map_session_data *tsd=(struct map_session_data *)target;

		if(tsd && tsd->sc_data && tsd->sc_data[SC_DEVOTION].val1){	// fB{[VĂ
			struct map_session_data *md = map_id2sd(tsd->sc_data[SC_DEVOTION].val1);
			if(md && skill_devotion3(&md->bl,target->id)){
				skill_devotion(md,target->id);
			}
			else if(md && bl)
				for(i=0;i<5;i++)
					if(md->dev.val1[i] == target->id){
						clif_damage(bl,&md->bl, gettick(), 0, 0, 
							damage, 0 , 0, 0);
						pc_damage(&md->bl,md,damage);

						return 0;
					}
		}

		if(tsd && tsd->skilltimer!=-1){	// rWQ
				// tFJ[hWQȂXĽ
			if( (!tsd->special_state.no_castcancel || map[bl->m].flag.gvg) && tsd->state.skillcastcancel &&
				!tsd->special_state.no_castcancel2)
				skill_castcancel(target,0);
		}

		return pc_damage(bl,tsd,damage);

	}
	else if(target->type==BL_SKILL)
		return skill_unit_ondamaged((struct skill_unit *)target,bl,damage,gettick());
	return 0;
}
int battle_heal(struct block_list *bl,struct block_list *target,int hp,int sp,int flag)
{
	if( target == NULL ){ //blNULLŌĂ΂邱Ƃ̂őŃ`FbN
		printf("battle_heal nullpo\n");
		return 0;
	}

	if(target->type == BL_PET)
		return 0;
	if( target->type ==BL_PC && pc_isdead((struct map_session_data *)target) )
		return 0;
	if(hp==0 && sp==0)
		return 0;

	if(hp<0)
		return battle_damage(bl,target,-hp,flag);

	if(target->type==BL_MOB)
		return mob_heal((struct mob_data *)target,hp);
	else if(target->type==BL_PC)
		return pc_heal((struct map_session_data *)target,hp,sp);
	return 0;
}

// U~
int battle_stopattack(struct block_list *bl)
{
	if( bl == NULL ){
		printf("battle_stopattack nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB)
		return mob_stopattack((struct mob_data*)bl);
	else if(bl->type==BL_PC)
		return pc_stopattack((struct map_session_data*)bl);
	else if(bl->type==BL_PET)
		return pet_stopattack((struct pet_data*)bl);
	return 0;
}
// ړ~
int battle_stopwalking(struct block_list *bl,int type)
{
	if( bl == NULL ){
		printf("battle_stopwalking nullpo\n");
		return 0;
	}
	if(bl->type==BL_MOB)
		return mob_stop_walking((struct mob_data*)bl,type);
	else if(bl->type==BL_PC)
		return pc_stop_walking((struct map_session_data*)bl,type);
	else if(bl->type==BL_PET)
		return pet_stop_walking((struct pet_data*)bl,type);
	return 0;
}


/*==========================================
 * _[W̑C
 *------------------------------------------
 */
int battle_attr_fix(int damage,int atk_elem,int def_elem)
{
	int def_type= def_elem%10, def_lv=def_elem/10/2;

	if(	atk_elem<0 || atk_elem>9 || def_type<0 || def_type>9 ||
		def_lv<1 || def_lv>4){	//  l̂łƂ肠̂܂ܕԂ
		if(battle_config.error_log)
			printf("battle_attr_fix: unknown attr type: atk=%d def_type=%d def_lv=%d\n",atk_elem,def_type,def_lv);
		return damage;
	}

	return damage*attr_fix_table[def_lv-1][atk_elem][def_type]/100;
}


/*==========================================
 * _[WŏIvZ
 *------------------------------------------
 */
int battle_calc_damage(struct block_list *src,struct block_list *bl,int damage,int div_,int skill_num,int skill_lv,int flag)
{
	struct map_session_data *sd=NULL;
	struct mob_data *md=NULL;
	struct status_change *sc_data,*sc;
	short *sc_count;
	int class;

	if( bl == NULL ){
		printf("battle_calc_damage nullpo\n");
		return 0;
	}

	class = battle_get_class(bl);
	if(bl->type==BL_MOB) md=(struct mob_data *)bl;
	else sd=(struct map_session_data *)bl;
	
	sc_data=battle_get_sc_data(bl);
	sc_count=battle_get_sc_count(bl);

	if(sc_count!=NULL && *sc_count>0){

		if(sc_data[SC_SAFETYWALL].timer!=-1 && damage>0 && flag&BF_WEAPON && flag&BF_SHORT && skill_num != NPC_GUIDEDATTACK){
			// Z[teBEH[
			struct skill_unit *unit=(struct skill_unit*)sc_data[SC_SAFETYWALL].val2;
			if( unit && unit->alive && (--unit->group->val2)<=0 )
				skill_delunit(unit);
			skill_unit_move(bl,gettick(),1);	// dˊ|`FbN
			damage=0;
		}
		if(sc_data[SC_PNEUMA].timer!=-1 && damage>0 && flag&BF_WEAPON && flag&BF_LONG && skill_num != NPC_GUIDEDATTACK){
			// j[}
			damage=0;
		}
		
		if(sc_data[SC_AETERNA].timer!=-1 && damage>0){	// bNXG[ei
			damage<<=1;
			skill_status_change_end( bl,SC_AETERNA,-1 );
		}

		//̃_[W
		if(sc_data[SC_VOLCANO].timer!=-1){	// {P[m
			if(flag&BF_SKILL && skill_get_pl(skill_num)==3)
				damage += damage*sc_data[SC_VOLCANO].val4/100;
			else if(!flag&BF_SKILL && battle_get_attack_element(bl)==3)
				damage += damage*sc_data[SC_VOLCANO].val4/100;
		}

		if(sc_data[SC_VIOLENTGALE].timer!=-1){	// oCIgQC
			if(flag&BF_SKILL && skill_get_pl(skill_num)==4)
				damage += damage*sc_data[SC_VIOLENTGALE].val4/100;
			else if(!flag&BF_SKILL && battle_get_attack_element(bl)==4)
				damage += damage*sc_data[SC_VIOLENTGALE].val4/100;
		}

		if(sc_data[SC_DELUGE].timer!=-1){	// f[W
			if(flag&BF_SKILL && skill_get_pl(skill_num)==1)
				damage += damage*sc_data[SC_DELUGE].val4/100;
			else if(!flag&BF_SKILL && battle_get_attack_element(bl)==1)
				damage += damage*sc_data[SC_DELUGE].val4/100;
		}

		if(sc_data[SC_ENERGYCOAT].timer!=-1 && damage>0  && flag&BF_WEAPON){	// GiW[R[g
			if(sd){
				if(sd->status.sp>0){
					int per = sd->status.sp * 5 / (sd->status.max_sp + 1);
					sd->status.sp -= sd->status.sp * (per * 5 + 10) / 1000;
					if( sd->status.sp < 0 ) sd->status.sp = 0;
					damage -= damage * ((per+1) * 6) / 100;
					clif_updatestatus(sd,SP_SP);
				}
				if(sd->status.sp<=0)
					skill_status_change_end( bl,SC_ENERGYCOAT,-1 );
			}
			else
				damage -= damage * (sc_data[SC_ENERGYCOAT].val1 * 6) / 100;
		}

		if(sc_data[SC_KYRIE].timer!=-1 && damage > 0){	// LGGC\
			sc=&sc_data[SC_KYRIE];
			sc->val2-=damage;
			if(flag&BF_WEAPON){
				if(sc->val2>=0)	damage=0;
				else damage=-sc->val2;
			}
			if((--sc->val3)<=0 || (sc->val2<=0) || skill_num == AL_HOLYLIGHT)
				skill_status_change_end(bl, SC_KYRIE, -1);
		}
		/* I[gK[h */
		if(sc_data[SC_AUTOGUARD].timer != -1 && damage > 0 && flag&BF_WEAPON) {
			if(rand()%100 < sc_data[SC_AUTOGUARD].val2) {
				damage = 0;
				clif_skill_nodamage(bl,bl,CR_AUTOGUARD,sc_data[SC_AUTOGUARD].val1,1);
				if(sd)
					sd->canmove_tick = gettick() + 300;
				else if(md)
					md->canmove_tick = gettick() + 300;
			}
		}
		/* pCO */
		if(sc_data[SC_PARRYING].timer != -1 && damage > 0 && flag&BF_WEAPON) {
			if(rand()%100 < sc_data[SC_PARRYING].val2) {
				damage = 0;
				clif_skill_nodamage(bl,bl,LK_PARRYING,sc_data[SC_PARRYING].val1,1);
			}
		}
		// WFNg\[h
		if(sc_data[SC_REJECTSWORD].timer!=-1 && damage > 0 && flag&BF_WEAPON &&
		  ((src->type==BL_PC && ((struct map_session_data *)src)->status.weapon == (1 || 2 || 3)) || src->type==BL_MOB )){
			if(rand()%100 < (10+5*sc_data[SC_REJECTSWORD].val1)){ //ˊm10+5*Lv
				damage = damage*50/100;
				battle_damage(bl,src,damage,0);
				//_[W^̂͗ǂ񂾂Aǂĕ\񂾂킩˂
				//GtFNgł̂킩˂
				clif_skill_nodamage(bl,bl,ST_REJECTSWORD,sc_data[SC_REJECTSWORD].val1,1);
				if((--sc_data[SC_REJECTSWORD].val2)<=0)
					skill_status_change_end(bl, SC_REJECTSWORD, -1);
			}
		}
	}

	if(class == 1288 || class == 1287 || class == 1286 || class == 1285) {
//	if(class == 1288) {
		if(flag&BF_SKILL)
			damage=0;
		if(src->type == BL_PC) {
			struct guild *g=guild_search(((struct map_session_data *)src)->status.guild_id);
			struct guild_castle *gc=guild_mapname2gc(map[bl->m].name);

			if(g == NULL)
				damage=0;//MhȂ_[W
			else if((gc != NULL) && g->guild_id == gc->guild_id)
				damage=0;//̃Mh̃GyȂ_[W
			else if(guild_checkskill(g,GD_APPROVAL) <= 0)
				damage=0;//KMhFȂƃ_[W
		}
		else damage = 0;
	}
	if(map[bl->m].flag.gvg && damage > 0) { //GvG
		if(flag&BF_WEAPON) {
			if(flag&BF_SHORT)
				damage=damage*battle_config.gvg_short_damage_rate/100;
			if(flag&BF_LONG)
				damage=damage*battle_config.gvg_long_damage_rate/100;
		}
		if(flag&BF_MAGIC)
			damage = damage*battle_config.gvg_magic_damage_rate/100;
		if(flag&BF_MISC)
			damage=damage*battle_config.gvg_misc_damage_rate/100;
		if(damage < 1) damage  = 1;
	}

	if(battle_config.skill_min_damage || flag&BF_MISC) {
		if(div_ < 255) {
			if(damage > 0 && damage < div_)
				damage = div_;
		}
		else if(damage > 0 && damage < 3)
			damage = 3;
	}

	if( md!=NULL && md->hp>0 && damage > 0 )	// ȂǂMOBXL
		mobskill_event(md,flag);

	return damage;
}

/*==========================================
 * C_[W
 *------------------------------------------
 */
int battle_addmastery(struct map_session_data *sd,struct block_list *target,int dmg,int type)
{
	int damage,skill;
	int race=battle_get_race(target);
	int weapon;
	damage = 0;

	if( sd == NULL ){
		printf("battle_addmastery nullpo\n");
		return 0;
	}

	// f[xC(+3 ` +30) vs s or  (l͊܂߂ȂH)
	if((skill = pc_checkskill(sd,AL_DEMONBANE)) > 0 && (battle_check_undead(race,battle_get_elem_type(target)) || race==6) ) 
		damage += (skill * 3);

	// r[XgxC(+4 ` +40) vs  or 
	if((skill = pc_checkskill(sd,HT_BEASTBANE)) > 0 && (race==2 || race==4) ) 
		damage += (skill * 4);

	if(type == 0)
		weapon = sd->weapontype1;
	else
		weapon = sd->weapontype2;
	switch(weapon)
	{
		case 0x01:	// Z (Updated By AppleGirl)
		case 0x02:	// 1HS
		{
			// C(+4 ` +40) Ў茕 Z܂
			if((skill = pc_checkskill(sd,SM_SWORD)) > 0) {
				damage += (skill * 4);
			}
			break;
		}
		case 0x03:	// 2HS
		{
			// 茕C(+4 ` +40) 茕
			if((skill = pc_checkskill(sd,SM_TWOHAND)) > 0) {
				damage += (skill * 4);
			}
			break;
		}
		case 0x04:	// 1HL
		{
			// C(+4 ` +40,+5 ` +50) 
			if((skill = pc_checkskill(sd,KN_SPEARMASTERY)) > 0) {
				if(!pc_isriding(sd))
					damage += (skill * 4);	// yRɏĂȂ
				else
					damage += (skill * 5);	// yRɏĂ
			}
			break;
		}
		case 0x05:	// 2HL
		{
			// C(+4 ` +40,+5 ` +50) 
			if((skill = pc_checkskill(sd,KN_SPEARMASTERY)) > 0) {
				if(!pc_isriding(sd))
					damage += (skill * 4);	// yRɏĂȂ
				else
					damage += (skill * 5);	// yRɏĂ
			}
			break;
		}
		case 0x06:	// Ў蕀
		{
			if((skill = pc_checkskill(sd,AM_AXEMASTERY)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x07: // Axe by Tato
		{
			if((skill = pc_checkskill(sd,AM_AXEMASTERY)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x08:	// CX
		{
			// CXC(+3 ` +30) CX
			if((skill = pc_checkskill(sd,PR_MACEMASTERY)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x09:	// Ȃ?
			break;
		case 0x0a:	// 
			break;
		case 0x0b:	// |
			break;
		case 0x00:	// f
		case 0x0c:	// Knuckles
		{
			// S(+3 ` +30) f,ibN
			if((skill = pc_checkskill(sd,MO_IRONHAND)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x0d:	// Musical Instrument
		{
			// y̗K(+3 ` +30) y
			if((skill = pc_checkskill(sd,BA_MUSICALLESSON)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x0e:	// Dance Mastery
		{
			// Dance Lesson Skill Effect(+3 damage for every lvl = +30) 
			if((skill = pc_checkskill(sd,DC_DANCINGLESSON)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x0f:	// Book
		{
			// Advance Book Skill Effect(+3 damage for every lvl = +30) {
			if((skill = pc_checkskill(sd,SA_ADVANCEDBOOK)) > 0) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x10:	// Katars
		{
			// J^[C(+3 ` +30) J^[
			if((skill = pc_checkskill(sd,AS_KATAR)) > 0) {
				//\jbNu[͕ʏi1ɕt1/8K)
				damage += (skill * 3);
			}
			// AhoXhJ^[
			if((skill = pc_checkskill(sd,ASC_KATAR)) > 0) {
				damage += damage*(10+(skill * 2))/100;
			}
			
			break;
		}
	}
	damage = dmg + damage;
	return (damage);
}

static struct Damage battle_calc_pet_weapon_attack(
	struct block_list *src,struct block_list *target,int skill_num,int skill_lv,int wflag)
{
	struct pet_data *pd = (struct pet_data *)src;
	struct mob_data *tmd=NULL;
	int hitrate,flee,cri = 0,atkmin,atkmax;
	int luk,target_count = 1;
	int def1 = battle_get_def(target);
	int def2 = battle_get_def2(target);
	int t_vit = battle_get_vit(target);
	struct Damage wd;
	int damage,damage2=0,type,div_,blewcount=skill_get_blewcount(skill_num,skill_lv);
	int flag,dmg_lv=0;
	int t_mode=0,t_race=0,t_size=1,s_race=0,s_ele=0;
	struct status_change *t_sc_data;

	if( target == NULL || pd == NULL ){ //src͓eɒڐGĂȂ̂ŃX[Ă݂
		printf("battle_calc_pet_weapon_attack nullpo\n");
		memset(&wd,0,sizeof(wd));
		return wd;
	}

	s_race=battle_get_race(src);
	s_ele=battle_get_attack_element(src);

	// ^[Qbg
	if(target->type == BL_MOB)
		tmd=(struct mob_data *)target;
	else {
		memset(&wd,0,sizeof(wd));
		return wd;
	}
	t_race=battle_get_race( target );
	t_size=battle_get_size( target );
	t_mode=battle_get_mode( target );
	t_sc_data=battle_get_sc_data( target );

	flag=BF_SHORT|BF_WEAPON|BF_NORMAL;	// U̎ނ̐ݒ
	
	// 𗦌vZA𔻒͌
	flee = battle_get_flee(target);
	if(battle_config.agi_penaly_type > 0 || battle_config.vit_penaly_type > 0)
		target_count += battle_counttargeted(target,src,battle_config.agi_penaly_count_lv);
	if(battle_config.agi_penaly_type > 0) {
		if(target_count >= battle_config.agi_penaly_count) {
			if(battle_config.agi_penaly_type == 1)
				flee = (flee * (100 - (target_count - (battle_config.agi_penaly_count - 1))*battle_config.agi_penaly_num))/100;
			else if(battle_config.agi_penaly_type == 2)
				flee -= (target_count - (battle_config.agi_penaly_count - 1))*battle_config.agi_penaly_num;
			if(flee < 1) flee = 1;
		}
	}
	hitrate=battle_get_hit(src) - flee + 80;

	type=0;	// normal
	div_ = 1; // single attack

	luk=battle_get_luk(src);

	if(battle_config.pet_str)
		damage = battle_get_baseatk(src);
	else
		damage = 0;

	if(skill_num==HW_MAGICCRASHER){			/* }WbNNbV[MATKŉ */
		atkmin = battle_get_matk1(src);
		atkmax = battle_get_matk2(src);
	}else{
		atkmin = battle_get_atk(src);
		atkmax = battle_get_atk2(src);
	}
	if(mob_db[pd->class].range>3 )
		flag=(flag&~BF_RANGEMASK)|BF_LONG;

	if(atkmin > atkmax) atkmin = atkmax;

	cri = battle_get_critical(src);
	cri -= battle_get_luk(target) * 3;
	if(battle_config.enemy_critical_rate != 100) {
		cri = cri*battle_config.enemy_critical_rate/100;
		if(cri < 1)
			cri = 1;
	}
	if(t_sc_data != NULL && t_sc_data[SC_SLEEP].timer!=-1 )
		cri <<=1;

	if(skill_num == 0 && skill_lv >= 0 && battle_config.enemy_critical && (rand() % 1000) < cri)
	{
		damage += atkmax;
		type = 0x0a;
	}
	else {
		int vitbonusmax;
	
		if(atkmax > atkmin)
			damage += atkmin + rand() % (atkmax-atkmin + 1);
		else
			damage += atkmin ;
		// XLCPiU͔{nj
		// I[o[gXg(+5% ` +25%),UnXL̏ꍇŕ␳
		// obV,}OiuCN,
		// {[OobV,XsAu[,ufBbVXsA,XsAX^bu,
		// }[iCg,J[g{[V
		// _uXgCtBO,A[V[,`[WA[,
		// \jbNu[
		if(skill_num>0){
			int i;
			if( (i=skill_get_pl(skill_num))>0 )
				s_ele=i;

			flag=(flag&~BF_SKILLMASK)|BF_SKILL;
			switch( skill_num ){
			case SM_BASH:		// obV
				damage = damage*(100+ 30*skill_lv)/100;
				hitrate = (hitrate*(100+5*skill_lv))/100;
				break;
			case SM_MAGNUM:		// }OiuCN
				damage = damage*(5*skill_lv +(wflag)?65:115 )/100;
				break;
			case MC_MAMMONITE:	// }[iCg
				damage = damage*(100+ 50*skill_lv)/100;
				break;
			case AC_DOUBLE:	// _uXgCtBO
				damage = damage*(180+ 20*skill_lv)/100;
				div_=2;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case AC_SHOWER:	// A[V[
				damage = damage*(75 + 5*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case AC_CHARGEARROW:	// `[WA[
				damage = damage*150/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case KN_PIERCE:	// sA[X
				damage = damage*(100+ 10*skill_lv)/100;
				hitrate = hitrate*(100+5*skill_lv)/100;
				div_=t_size+1;
				damage*=div_;
				break;
			case KN_SPEARSTAB:	// XsAX^u
				damage = damage*(100+ 15*skill_lv)/100;
				break;
			case KN_SPEARBOOMERANG:	// XsAu[
				damage = damage*(100+ 50*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case KN_BRANDISHSPEAR: // ufBbVXsA
				damage = damage*(100+ 20*skill_lv)/100;
				if(skill_lv>3 && wflag==1) damage2+=damage/2;
				if(skill_lv>6 && wflag==1) damage2+=damage/4;
				if(skill_lv>9 && wflag==1) damage2+=damage/8;
				if(skill_lv>6 && wflag==2) damage2+=damage/2;
				if(skill_lv>9 && wflag==2) damage2+=damage/4;
				if(skill_lv>9 && wflag==3) damage2+=damage/2;
				damage +=damage2;
				blewcount=0;
				break;
			case KN_BOWLINGBASH:	// {EOobV
				damage = damage*(100+ 50*skill_lv)/100;
				blewcount=0;
				break;
			case AS_SONICBLOW:	// \jbNuE
				damage = damage*(300+ 50*skill_lv)/100;
				div_=8;
				break;
			case TF_SPRINKLESAND:	// ܂
				damage = damage*125/100;
				break;
			case MC_CARTREVOLUTION:	// J[g{[V
				damage = (damage*150)/100;
				break;
			// ȉMOB
			case NPC_COMBOATTACK:	// iU
				div_=skill_get_num(skill_num,skill_lv);
				damage *= div_;
				break;
			case NPC_RANDOMATTACK:	// _ATKU
				damage = damage*(50+rand()%150)/100;
				break;
			// UiKj
			case NPC_WATERATTACK:
			case NPC_GROUNDATTACK:
			case NPC_FIREATTACK:
			case NPC_WINDATTACK:
			case NPC_POISONATTACK:
			case NPC_HOLYATTACK:
			case NPC_DARKNESSATTACK:
			case NPC_TELEKINESISATTACK:
				damage = damage*(100+25*(skill_lv-1))/100;
				break;
			case NPC_GUIDEDATTACK:
				hitrate = 1000000;
				break;
			case NPC_RANGEATTACK:
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case NPC_PIERCINGATT:
				flag=(flag&~BF_RANGEMASK)|BF_SHORT;
				break;
			case RG_BACKSTAP:	// obNX^u
				damage = damage*(300+ 40*skill_lv)/100;
				hitrate = 1000000;
				break;
			case RG_RAID:	// TvCYA^bN
				damage = damage*(100+ 40*skill_lv)/100;
				break;
			case RG_INTIMIDATE:	// CeB~fCg
				damage = damage*(100+ 30*skill_lv)/100;
				break;
			case CR_SHIELDCHARGE:	// V[h`[W
				damage = damage*(100+ 20*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_SHORT;
				s_ele = 0;
				break;
			case CR_SHIELDBOOMERANG:	// V[hu[
				damage = damage*(100+ 30*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				s_ele = 0;
				break;
			case CR_HOLYCROSS:	// z[[NX
				damage = damage*(100+ 35*skill_lv)/100;
				div_=2;
				break;
			case CR_GRANDCROSS:
				hitrate= 1000000;
				break;
			case AM_DEMONSTRATION:	// fXg[V
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				break;
			case AM_ACIDTERROR:	// AVbhe[
				damage = damage*(100+ 40*skill_lv)/100;
				damage2 = damage2*(100+ 40*skill_lv)/100;
				break;
			case MO_FINGEROFFENSIVE:	//we
				damage = damage * (100 + 50 * skill_lv) / 100;
				div_ = 1;
				break;
			case MO_INVESTIGATE:	//  
				if(def1 < 1000000)
					damage = damage*(100+ 75*skill_lv)/100 * (def1 + def2)/100;
				hitrate = 1000000;
				s_ele = 0;
				break;
			case MO_EXTREMITYFIST:	// CeP
				damage = damage * 8 + 250 + (skill_lv * 150);
				hitrate = 1000000;
				s_ele = 0;
				break;
			case MO_CHAINCOMBO:	// Aŏ
				damage = damage*(150+ 50*skill_lv)/100;
				div_=4;
				break;
			case MO_COMBOFINISH:	// җ
				damage = damage*(240+ 60*skill_lv)/100;
				break;
			case DC_THROWARROW:	// 
				damage = damage*(100+ 50 * skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case BA_MUSICALSTRIKE:	// ~[WJXgCN
				damage = damage*(100+ 50 * skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case CH_TIGERFIST:	// Ռ
				damage = damage*(100+ 20*skill_lv)/100;
				break;
			case CH_CHAINCRUSH:	// A
				damage = damage*(100+ 20*skill_lv)/100;
				div_=skill_get_num(skill_num,skill_lv);
				break;
			case CH_PALMSTRIKE:	// ҌՍdhR
				damage = damage*(50+ 100*skill_lv)/100;
				break;
			case LK_SPIRALPIERCE:			/* XpCsA[X */
				damage = damage*(100+ 50*skill_lv)/100; //ʂȂ̂œK
				div_=5;
				if(target->type == BL_PC)
					((struct map_session_data *)target)->canmove_tick = gettick() + 1000;
				else if(target->type == BL_MOB)
					((struct mob_data *)target)->canmove_tick = gettick() + 1000;
				break;
			case LK_HEADCRUSH:				/* wbhNbV */
				damage = damage*(100+ 20*skill_lv)/100;
				break;
			case LK_JOINTBEAT:				/* WCgr[g */
				damage = damage*(50+ 10*skill_lv)/100;
				break;
			case ASC_METEORASSAULT:			/* eIATg */
				damage = damage*(40+ 40*skill_lv)/100;
				break;
			case SN_SHARPSHOOTING:			/* V[vV[eBO */
				damage += damage*(30*skill_lv)/100;
				break;
			case CG_ARROWVULCAN:			/* A[oJ */
				damage = damage*(160+40*skill_lv)/100;
				div_=9;
				break;
			}
		}

		if( skill_num!=NPC_CRITICALSLASH ){
			//  ۂ̖h͂ɂ_[W̌
			// fBoCveNVił̂ȁHj
			if ( skill_num != MO_INVESTIGATE && skill_num != MO_EXTREMITYFIST && skill_num != KN_AUTOCOUNTER && def1 < 1000000 ) {	//DEF, VIT
				int t_def;
				target_count = 1 + battle_counttargeted(target,src,battle_config.vit_penaly_count_lv);
				if(battle_config.vit_penaly_type > 0) {
					if(target_count >= battle_config.vit_penaly_count) {
						if(battle_config.vit_penaly_type == 1) {
							def1 = (def1 * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
							def2 = (def2 * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
							t_vit = (t_vit * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
						}
						else if(battle_config.vit_penaly_type == 2) {
							def1 -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
							def2 -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
							t_vit -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
						}
						if(def1 < 0) def1 = 0;
						if(def2 < 1) def2 = 1;
						if(t_vit < 1) t_vit = 1;
					}
				}
				t_def = def2*8/10;
				vitbonusmax = (t_vit/20)*(t_vit/20)-1;
				if(battle_config.pet_defense_type) {
					damage = damage - (def1 * battle_config.pet_defense_type) - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
				}
				else{
					damage = damage * (100 - def1) /100 - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
				}
			}
		}
	}

	// 0ꍇ1ɕ␳
	if(damage<1) damage=1;

	// C
	if(hitrate < 1000000)
		hitrate = ( (hitrate>95)?95: ((hitrate<5)?5:hitrate) );
	if(	hitrate < 1000000 &&			// KU
		(t_sc_data != NULL && (t_sc_data[SC_SLEEP].timer!=-1 ||	// ͕K
		t_sc_data[SC_STAN].timer!=-1 ||		// X^͕K
		t_sc_data[SC_FREEZE].timer!=-1 || (t_sc_data[SC_STONE].timer!=-1 && t_sc_data[SC_STONE].val2==0) ) ) )	// ͕K
		hitrate = 1000000;
	if(type == 0 && rand()%100 >= hitrate) {
		damage = damage2 = 0;
		dmg_lv = ATK_FLEE;
	} else {
		dmg_lv = ATK_DEF;
	}

	
	if(t_sc_data) {
		int cardfix=100;
		if(t_sc_data[SC_DEFENDER].timer != -1 && flag&BF_LONG)
			cardfix=cardfix*(100-t_sc_data[SC_DEFENDER].val2)/100;
		if(cardfix != 100)
			damage=damage*cardfix/100;
	}
	if(damage < 0) damage = 0;

	//  ̓Kp
	if(skill_num != 0 || s_ele != 0 || !battle_config.pet_attack_attr_none)
		damage=battle_attr_fix(damage, s_ele, battle_get_element(target) );

	if(skill_num==PA_PRESSURE) /* vbV[ K? */
		damage = 700+100*skill_lv;

	// CxiC
	if(skill_num==TF_POISON){
		damage = battle_attr_fix(damage + 15*skill_lv, s_ele, battle_get_element(target) );
	}
	if(skill_num==MC_CARTREVOLUTION){
		damage = battle_attr_fix(damage, 0, battle_get_element(target) );
	}

	// S̔
	if(battle_config.enemy_perfect_flee) {
		if(skill_num == 0 && skill_lv >= 0 && tmd!=NULL && rand()%1000 < battle_get_flee2(target) ){
			damage=0;
			type=0x0b;
			dmg_lv = ATK_LUCKY;
		}
	}

//	if(def1 >= 1000000 && damage > 0)
	if(t_mode&0x40 && damage > 0)
		damage = 1;

	if(skill_num != CR_GRANDCROSS)
		damage=battle_calc_damage(src,target,damage,div_,skill_num,skill_lv,flag);

	wd.damage=damage;
	wd.damage2=0;
	wd.type=type;
	wd.div_=div_;
	wd.amotion=battle_get_amotion(src);
	if(skill_num == KN_AUTOCOUNTER)
		wd.amotion >>= 1;
	wd.dmotion=battle_get_dmotion(target);
	wd.blewcount=blewcount;
	wd.flag=flag;
	wd.dmg_lv=dmg_lv;

	return wd;
}

static struct Damage battle_calc_mob_weapon_attack(
	struct block_list *src,struct block_list *target,int skill_num,int skill_lv,int wflag)
{
	struct map_session_data *tsd=NULL;
	struct mob_data* md=(struct mob_data *)src,*tmd=NULL;
	int hitrate,flee,cri = 0,atkmin,atkmax;
	int luk,target_count = 1;
	int def1 = battle_get_def(target);
	int def2 = battle_get_def2(target);
	int t_vit = battle_get_vit(target);
	struct Damage wd;
	int damage,damage2=0,type,div_,blewcount=skill_get_blewcount(skill_num,skill_lv);
	int flag,skill,ac_flag = 0,dmg_lv = 0;
	int t_mode=0,t_race=0,t_size=1,s_race=0,s_ele=0;
	struct status_change *sc_data,*t_sc_data;
	short *sc_count;
	short *option, *opt1, *opt2;

	if( src == NULL || target == NULL || md == NULL ){
		printf("battle_calc_mob_weapon_attack nullpo\n");
		memset(&wd,0,sizeof(wd));
		return wd;
	}

	s_race=battle_get_race(src);
	s_ele=battle_get_attack_element(src);
	sc_data=battle_get_sc_data(src);
	sc_count=battle_get_sc_count(src);
	option=battle_get_option(src);
	opt1=battle_get_opt1(src);
	opt2=battle_get_opt2(src);
	
	// ^[Qbg
	if(target->type==BL_PC)
		tsd=(struct map_session_data *)target;
	else if(target->type==BL_MOB)
		tmd=(struct mob_data *)target;
	t_race=battle_get_race( target );
	t_size=battle_get_size( target );
	t_mode=battle_get_mode( target );
	t_sc_data=battle_get_sc_data( target );

	if((skill_num == 0 || (target->type == BL_PC && battle_config.pc_auto_counter_type&2) ||
		(target->type == BL_MOB && battle_config.monster_auto_counter_type&2)) && skill_lv >= 0) {
		if(skill_num != CR_GRANDCROSS && t_sc_data && t_sc_data[SC_AUTOCOUNTER].timer != -1) {
			int dir = map_calc_dir(src,target->x,target->y),t_dir = battle_get_dir(target);
			int dist = distance(src->x,src->y,target->x,target->y);
			if(dist <= 0 || map_check_dir(dir,t_dir) ) {
				memset(&wd,0,sizeof(wd));
				t_sc_data[SC_AUTOCOUNTER].val3 = 0;
				t_sc_data[SC_AUTOCOUNTER].val4 = 1;
				if(sc_data && sc_data[SC_AUTOCOUNTER].timer == -1) {
					int range = battle_get_range(target);
					if((target->type == BL_PC && ((struct map_session_data *)target)->status.weapon != 11 && dist <= range+1) ||
						(target->type == BL_MOB && range <= 3 && dist <= range+1) )
						t_sc_data[SC_AUTOCOUNTER].val3 = src->id;
				}
				return wd;
			}
			else ac_flag = 1;
		}
	}
	flag=BF_SHORT|BF_WEAPON|BF_NORMAL;	// U̎ނ̐ݒ

	// 𗦌vZA𔻒͌
	flee = battle_get_flee(target);
	if(battle_config.agi_penaly_type > 0 || battle_config.vit_penaly_type > 0)
		target_count += battle_counttargeted(target,src,battle_config.agi_penaly_count_lv);
	if(battle_config.agi_penaly_type > 0) {
		if(target_count >= battle_config.agi_penaly_count) {
			if(battle_config.agi_penaly_type == 1)
				flee = (flee * (100 - (target_count - (battle_config.agi_penaly_count - 1))*battle_config.agi_penaly_num))/100;
			else if(battle_config.agi_penaly_type == 2)
				flee -= (target_count - (battle_config.agi_penaly_count - 1))*battle_config.agi_penaly_num;
			if(flee < 1) flee = 1;
		}
	}
	hitrate=battle_get_hit(src) - flee + 80;

	type=0;	// normal
	div_ = 1; // single attack

	luk=battle_get_luk(src);

	if(battle_config.enemy_str)
		damage = battle_get_baseatk(src);
	else
		damage = 0;
	if(skill_num==HW_MAGICCRASHER){			/* }WbNNbV[MATKŉ */
		atkmin = battle_get_matk1(src);
		atkmax = battle_get_matk2(src);
	}else{
		atkmin = battle_get_atk(src);
		atkmax = battle_get_atk2(src);
	}
	if(mob_db[md->class].range>3 )
		flag=(flag&~BF_RANGEMASK)|BF_LONG;

	if(atkmin > atkmax) atkmin = atkmax;

	if(sc_data != NULL && sc_data[SC_MAXIMIZEPOWER].timer!=-1 ){	// }LV}CYp[
		atkmin=atkmax;
	}

	cri = battle_get_critical(src);
	cri -= battle_get_luk(target) * 3;
	if(battle_config.enemy_critical_rate != 100) {
		cri = cri*battle_config.enemy_critical_rate/100;
		if(cri < 1)
			cri = 1;
	}
	if(t_sc_data != NULL && t_sc_data[SC_SLEEP].timer!=-1 )	// ̓NeBJ{
		cri <<=1;

	if(ac_flag) cri = 1000;

	if(skill_num == KN_AUTOCOUNTER) {
		if(!(battle_config.monster_auto_counter_type&1))
			cri = 1000;
		else
			cri <<= 1;
	}

	if(tsd && tsd->critical_def)
		cri = cri * (100 - tsd->critical_def) / 100;

	if((skill_num == 0 || skill_num == KN_AUTOCOUNTER) && skill_lv >= 0 && battle_config.enemy_critical && (rand() % 1000) < cri) 	// iXL̏ꍇ͖j
			// G̔
	{
		damage += atkmax;
		type = 0x0a;
	}
	else {
		int vitbonusmax;
	
		if(atkmax > atkmin)
			damage += atkmin + rand() % (atkmax-atkmin + 1);
		else
			damage += atkmin ;
		// XLCPiU͔{nj
		// I[o[gXg(+5% ` +25%),UnXL̏ꍇŕ␳
		// obV,}OiuCN,
		// {[OobV,XsAu[,ufBbVXsA,XsAX^bu,
		// }[iCg,J[g{[V
		// _uXgCtBO,A[V[,`[WA[,
		// \jbNu[
		if(sc_data){ //Ԉُ풆̃_[Wǉ
			if(sc_data[SC_OVERTHRUST].timer!=-1)	// I[o[gXg
				damage += damage*(5*sc_data[SC_OVERTHRUST].val1)/100;
			if(sc_data[SC_TRUESIGHT].timer!=-1)	// gD[TCg
				damage += damage*(2*sc_data[SC_TRUESIGHT].val1)/100;
			if(sc_data[SC_BERSERK].timer!=-1)	// o[T[N
				damage += damage*50/100;
		}

		if(skill_num>0){
			int i;
			if( (i=skill_get_pl(skill_num))>0 )
				s_ele=i;

			flag=(flag&~BF_SKILLMASK)|BF_SKILL;
			switch( skill_num ){
			case SM_BASH:		// obV
				damage = damage*(100+ 30*skill_lv)/100;
				hitrate = (hitrate*(100+5*skill_lv))/100;
				break;
			case SM_MAGNUM:		// }OiuCN
				damage = damage*(5*skill_lv +(wflag)?65:115 )/100;
				break;
			case MC_MAMMONITE:	// }[iCg
				damage = damage*(100+ 50*skill_lv)/100;
				break;
			case AC_DOUBLE:	// _uXgCtBO
				damage = damage*(180+ 20*skill_lv)/100;
				div_=2;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case AC_SHOWER:	// A[V[
				damage = damage*(75 + 5*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case AC_CHARGEARROW:	// `[WA[
				damage = damage*150/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case KN_PIERCE:	// sA[X
				damage = damage*(100+ 10*skill_lv)/100;
				hitrate=hitrate*(100+5*skill_lv)/100;
				div_=t_size+1;
				damage*=div_;
				break;
			case KN_SPEARSTAB:	// XsAX^u
				damage = damage*(100+ 15*skill_lv)/100;
				break;
			case KN_SPEARBOOMERANG:	// XsAu[
				damage = damage*(100+ 50*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case KN_BRANDISHSPEAR: // ufBbVXsA
				damage = damage*(100+ 20*skill_lv)/100;
				if(skill_lv>3 && wflag==1) damage2+=damage/2;
				if(skill_lv>6 && wflag==1) damage2+=damage/4;
				if(skill_lv>9 && wflag==1) damage2+=damage/8;
				if(skill_lv>6 && wflag==2) damage2+=damage/2;
				if(skill_lv>9 && wflag==2) damage2+=damage/4;
				if(skill_lv>9 && wflag==3) damage2+=damage/2;
				damage +=damage2;
				blewcount=0;
				break;
			case KN_BOWLINGBASH:	// {EOobV
				damage = damage*(100+ 50*skill_lv)/100;
				blewcount=0;
				break;
			case KN_AUTOCOUNTER:
				if(battle_config.monster_auto_counter_type&1)
					hitrate += 20;
				else
					hitrate = 1000000;
				flag=(flag&~BF_SKILLMASK)|BF_NORMAL;
				break;
			case AS_SONICBLOW:	// \jbNuE
				damage = damage*(300+ 50*skill_lv)/100;
				div_=8;
				break;
			case TF_SPRINKLESAND:	// ܂
				damage = damage*125/100;
				break;
			case MC_CARTREVOLUTION:	// J[g{[V
				damage = (damage*150)/100;
				break;
			// ȉMOB
			case NPC_COMBOATTACK:	// iU
				div_=skill_get_num(skill_num,skill_lv);
				damage *= div_;
				break;
			case NPC_RANDOMATTACK:	// _ATKU
				damage = damage*(50+rand()%150)/100;
				break;
			// UiKj
			case NPC_WATERATTACK:
			case NPC_GROUNDATTACK:
			case NPC_FIREATTACK:
			case NPC_WINDATTACK:
			case NPC_POISONATTACK:
			case NPC_HOLYATTACK:
			case NPC_DARKNESSATTACK:
			case NPC_TELEKINESISATTACK:
				damage = damage*(100+25*(skill_lv-1))/100;
				break;
			case NPC_GUIDEDATTACK:
				hitrate = 1000000;
				break;
			case NPC_RANGEATTACK:
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case NPC_PIERCINGATT:
				flag=(flag&~BF_RANGEMASK)|BF_SHORT;
				break;
			case RG_BACKSTAP:	// obNX^u
				damage = damage*(300+ 40*skill_lv)/100;
				hitrate = 1000000;
				break;
			case RG_RAID:	// TvCYA^bN
				damage = damage*(100+ 40*skill_lv)/100;
				break;
			case RG_INTIMIDATE:	// CeB~fCg
				damage = damage*(100+ 30*skill_lv)/100;
				break;
			case CR_SHIELDCHARGE:	// V[h`[W
				damage = damage*(100+ 20*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_SHORT;
				s_ele = 0;
				break;
			case CR_SHIELDBOOMERANG:	// V[hu[
				damage = damage*(100+ 30*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				s_ele = 0;
				break;
			case CR_HOLYCROSS:	// z[[NX
				damage = damage*(100+ 35*skill_lv)/100;
				div_=2;
				break;
			case CR_GRANDCROSS:
				hitrate= 1000000;
				break;
			case AM_DEMONSTRATION:	// fXg[V
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				break;
			case AM_ACIDTERROR:	// AVbhe[
				damage = damage*(100+ 40*skill_lv)/100;
				damage2 = damage2*(100+ 40*skill_lv)/100;
				break;
			case MO_FINGEROFFENSIVE:	//we
				damage = damage * (100 + 50 * skill_lv) / 100;
				div_ = 1;
				break;
			case MO_INVESTIGATE:	//  
				if(def1 < 1000000)
					damage = damage*(100+ 75*skill_lv)/100 * (def1 + def2)/100;
				hitrate = 1000000;
				s_ele = 0;
				break;
			case MO_EXTREMITYFIST:	// CeP
				damage = damage * 8 + 250 + (skill_lv * 150);
				hitrate = 1000000;
				s_ele = 0;
				break;
			case MO_CHAINCOMBO:	// Aŏ
				damage = damage*(150+ 50*skill_lv)/100;
				div_=4;
				break;
			case BA_MUSICALSTRIKE:	// ~[WJXgCN
				damage = damage*(100+ 50 * skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case DC_THROWARROW:	// 
				damage = damage*(100+ 50 * skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case MO_COMBOFINISH:	// җ
				damage = damage*(240+ 60*skill_lv)/100;
				break;
			case CH_TIGERFIST:	// Ռ
				damage = damage*(100+ 20*skill_lv)/100;
				break;
			case CH_CHAINCRUSH:	// A
				damage = damage*(100+ 20*skill_lv)/100;
				div_=skill_get_num(skill_num,skill_lv);
				break;
			case CH_PALMSTRIKE:	// ҌՍdhR
				damage = damage*(50+ 100*skill_lv)/100;
				break;
			case LK_SPIRALPIERCE:			/* XpCsA[X */
				damage = damage*(100+ 50*skill_lv)/100; //ʂȂ̂œK
				div_=5;
				if(tsd)
					tsd->canmove_tick = gettick() + 1000;
				else if(tmd)
					tmd->canmove_tick = gettick() + 1000;
				break;
			case LK_HEADCRUSH:				/* wbhNbV */
				damage = damage*(100+ 20*skill_lv)/100;
				break;
			case LK_JOINTBEAT:				/* WCgr[g */
				damage = damage*(50+ 10*skill_lv)/100;
				break;
			case ASC_METEORASSAULT:			/* eIATg */
				damage = damage*(40+ 40*skill_lv)/100;
				break;
			case SN_SHARPSHOOTING:			/* V[vV[eBO */
				damage += damage*(30*skill_lv)/100;
				break;
			case CG_ARROWVULCAN:			/* A[oJ */
				damage = damage*(160+40*skill_lv)/100;
				div_=9;
				break;
			}
		}

		if( skill_num!=NPC_CRITICALSLASH ){
			//  ۂ̖h͂ɂ_[W̌
			// fBoCveNVił̂ȁHj
			if ( skill_num != MO_INVESTIGATE && skill_num != MO_EXTREMITYFIST && skill_num != KN_AUTOCOUNTER && def1 < 1000000) {	//DEF, VIT
				int t_def;
				target_count = 1 + battle_counttargeted(target,src,battle_config.vit_penaly_count_lv);
				if(battle_config.vit_penaly_type > 0) {
					if(target_count >= battle_config.vit_penaly_count) {
						if(battle_config.vit_penaly_type == 1) {
							def1 = (def1 * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
							def2 = (def2 * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
							t_vit = (t_vit * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
						}
						else if(battle_config.vit_penaly_type == 2) {
							def1 -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
							def2 -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
							t_vit -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
						}
						if(def1 < 0) def1 = 0;
						if(def2 < 1) def2 = 1;
						if(t_vit < 1) t_vit = 1;
					}
				}
				t_def = def2*8/10;
				if(battle_check_undead(s_race,battle_get_elem_type(src)) || s_race==6)
					if(tsd && (skill=pc_checkskill(tsd,AL_DP)) > 0 )
						t_def += skill*3;

				vitbonusmax = (t_vit/20)*(t_vit/20)-1;
				if(battle_config.monster_defense_type) {
					damage = damage - (def1 * battle_config.monster_defense_type) - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
				}
				else{
					damage = damage * (100 - def1) /100 - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
				}
			}
		}
	}

	// 0ꍇ1ɕ␳
	if(damage<1) damage=1;

	// C
	if(hitrate < 1000000)
		hitrate = ( (hitrate>95)?95: ((hitrate<5)?5:hitrate) );
	if(	hitrate < 1000000 &&			// KU
		(t_sc_data != NULL && (t_sc_data[SC_SLEEP].timer!=-1 ||	// ͕K
		t_sc_data[SC_STAN].timer!=-1 ||		// X^͕K
		t_sc_data[SC_FREEZE].timer!=-1 || (t_sc_data[SC_STONE].timer!=-1 && t_sc_data[SC_STONE].val2==0) ) ) )	// ͕K
		hitrate = 1000000;
	if(type == 0 && rand()%100 >= hitrate) {
		damage = damage2 = 0;
		dmg_lv = ATK_FLEE;
	} else {
		dmg_lv = ATK_DEF;
	}

	if(tsd){
		int cardfix=100,i;
		cardfix=cardfix*(100-tsd->subele[s_ele])/100;	//  ɂ_[Wϐ
		cardfix=cardfix*(100-tsd->subrace[s_race])/100;	// 푰ɂ_[Wϐ
		if(mob_db[md->class].mode & 0x20)
			cardfix=cardfix*(100-tsd->subrace[10])/100;
		else
			cardfix=cardfix*(100-tsd->subrace[11])/100;
		for(i=0;i<tsd->add_def_class_count;i++) {
			if(tsd->add_def_classid[i] == md->class) {
				cardfix=cardfix*(100-tsd->add_def_classrate[i])/100;
				break;
			}
		}
		if(flag&BF_LONG)
			cardfix=cardfix*(100-tsd->long_attack_def_rate)/100;
		if(flag&BF_SHORT)
			cardfix=cardfix*(100-tsd->near_attack_def_rate)/100;
		damage=damage*cardfix/100;
	}
	if(t_sc_data) {
		int cardfix=100;
		if(t_sc_data[SC_DEFENDER].timer != -1 && flag&BF_LONG)
			cardfix=cardfix*(100-t_sc_data[SC_DEFENDER].val2)/100;
		if(cardfix != 100)
			damage=damage*cardfix/100;
	}
	if(t_sc_data && t_sc_data[SC_ASSUMPTIO].timer != -1){ //AVveBI
		if(!map[target->m].flag.pvp)
			damage=damage/3;
		else
			damage=damage/2;
	}

	if(damage < 0) damage = 0;

	//  ̓Kp
	if(skill_num != 0 || s_ele != 0 || !battle_config.mob_attack_attr_none)
		damage=battle_attr_fix(damage, s_ele, battle_get_element(target) );

	if(sc_data && sc_data[SC_AURABLADE].timer!=-1)	/* I[u[h K */
		damage += sc_data[SC_AURABLADE].val1 * 10;
	if(skill_num==PA_PRESSURE) /* vbV[ K? */
		damage = 700+100*skill_lv;

	// CxiC
	if(skill_num==TF_POISON){
		damage = battle_attr_fix(damage + 15*skill_lv, s_ele, battle_get_element(target) );
	}
	if(skill_num==MC_CARTREVOLUTION){
		damage = battle_attr_fix(damage, 0, battle_get_element(target) );
	}

	// S̔
	if(skill_num == 0 && skill_lv >= 0 && tsd!=NULL && rand()%1000 < battle_get_flee2(target) ){
		damage=0;
		type=0x0b;
		dmg_lv = ATK_LUCKY;
	}

	if(battle_config.enemy_perfect_flee) {
		if(skill_num == 0 && skill_lv >= 0 && tmd!=NULL && rand()%1000 < battle_get_flee2(target) ){
			damage=0;
			type=0x0b;
			dmg_lv = ATK_LUCKY;
		}
	}

//	if(def1 >= 1000000 && damage > 0)
	if(t_mode&0x40 && damage > 0)
		damage = 1;

	if( tsd && tsd->special_state.no_weapon_damage)
		damage = 0;

	if(skill_num != CR_GRANDCROSS)
		damage=battle_calc_damage(src,target,damage,div_,skill_num,skill_lv,flag);

	wd.damage=damage;
	wd.damage2=0;
	wd.type=type;
	wd.div_=div_;
	wd.amotion=battle_get_amotion(src);
	if(skill_num == KN_AUTOCOUNTER)
		wd.amotion >>= 1;
	wd.dmotion=battle_get_dmotion(target);
	wd.blewcount=blewcount;
	wd.flag=flag;
	wd.dmg_lv=dmg_lv;
	return wd;
}
/*
 * =========================================================================
 * PC̕ɂU
 *-------------------------------------------------------------------------
 */
static struct Damage battle_calc_pc_weapon_attack(
	struct block_list *src,struct block_list *target,int skill_num,int skill_lv,int wflag)
{
	struct map_session_data *sd=(struct map_session_data *)src,*tsd=NULL;
	struct mob_data *tmd=NULL;
	int hitrate,flee,cri = 0,atkmin,atkmax;
	int dex,luk,target_count = 1;
	int def1 = battle_get_def(target);
	int def2 = battle_get_def2(target);
	int t_vit = battle_get_vit(target);
	struct Damage wd;
	int damage,damage2,damage3=0,damage4=0,type,div_,blewcount=skill_get_blewcount(skill_num,skill_lv);
	int flag,skill,dmg_lv = 0;
	int t_mode=0,t_race=0,t_size=1,s_race=7,s_ele=0;
	struct status_change *sc_data,*t_sc_data;
	short *sc_count;
	short *option, *opt1, *opt2;
	int atkmax_=0, atkmin_=0, s_ele_;	//񓁗p
	int watk,watk_,cardfix,t_ele;
	int da=0,i,t_class,ac_flag = 0;
	int idef_flag=0,idef_flag_=0;

	if( src == NULL || target == NULL || sd == NULL ){
		printf("battle_calc_pc_weapon_attack nullpo\n");
		memset(&wd,0,sizeof(wd));
		return wd;
	}

	// A^bJ[
	s_race=battle_get_race(src); //푰
	s_ele=battle_get_attack_element(src); //
	s_ele_=battle_get_attack_element2(src); //葮
	sc_data=battle_get_sc_data(src); //Xe[^Xُ
	sc_count=battle_get_sc_count(src); //Xe[^Xُ̐
	option=battle_get_option(src); //ƂyRƂJ[gƂ
	opt1=battle_get_opt1(src); //ΉAAX^AAÈ
	opt2=battle_get_opt2(src); //ŁA􂢁AفAÈŁH

	if(skill_num != CR_GRANDCROSS) //OhNXłȂȂ
		sd->state.attack_type = BF_WEAPON; //U^Cv͕U

	// ^[Qbg
	if(target->type==BL_PC) //ΏۂPCȂ
		tsd=(struct map_session_data *)target; //tsdɑ(tmdNULL)
	else if(target->type==BL_MOB) //ΏۂMobȂ
		tmd=(struct mob_data *)target; //tmdɑ(tsdNULL)
	t_race=battle_get_race( target ); //Ώۂ̎푰
	t_ele=battle_get_elem_type(target); //Ώۂ̑
	t_size=battle_get_size( target ); //Ώۂ̃TCY
	t_mode=battle_get_mode( target ); //ΏۂMode
	t_sc_data=battle_get_sc_data( target ); //Ώۂ̃Xe[^Xُ

//I[gJE^[
	if((skill_num == 0 || (target->type == BL_PC && battle_config.pc_auto_counter_type&2) ||
		(target->type == BL_MOB && battle_config.monster_auto_counter_type&2)) && skill_lv >= 0) {
		if(skill_num != CR_GRANDCROSS && t_sc_data && t_sc_data[SC_AUTOCOUNTER].timer != -1) { //OhNXłȂAΏۂI[gJE^[Ԃ̏ꍇ
			int dir = map_calc_dir(src,target->x,target->y),t_dir = battle_get_dir(target);
			int dist = distance(src->x,src->y,target->x,target->y);
			if(dist <= 0 || map_check_dir(dir,t_dir) ) { //ΏۂƂ̋0ȉA܂͑Ώۂ̐ʁH
				memset(&wd,0,sizeof(wd));
				t_sc_data[SC_AUTOCOUNTER].val3 = 0;
				t_sc_data[SC_AUTOCOUNTER].val4 = 1;
				if(sc_data && sc_data[SC_AUTOCOUNTER].timer == -1) { //I[gJE^[
					int range = battle_get_range(target);
					if((target->type == BL_PC && ((struct map_session_data *)target)->status.weapon != 11 && dist <= range+1) || //ΏۂPCŕ킪|łȂ˒
						(target->type == BL_MOB && range <= 3 && dist <= range+1) ) //܂͑ΏۂMobŎ˒3ȉŎ˒
						t_sc_data[SC_AUTOCOUNTER].val3 = src->id;
				}
				return wd; //_[W\̂ԂďI
			}
			else ac_flag = 1;
		}
	}
//I[gJE^[܂

	flag=BF_SHORT|BF_WEAPON|BF_NORMAL;	// U̎ނ̐ݒ

	// 𗦌vZA𔻒͌
	flee = battle_get_flee(target);
	if(battle_config.agi_penaly_type > 0 || battle_config.vit_penaly_type > 0) //AGIAVITyieBݒ肪L
		target_count += battle_counttargeted(target,src,battle_config.agi_penaly_count_lv);	//Ώۂ̐Zo
	if(battle_config.agi_penaly_type > 0) {
		if(target_count >= battle_config.agi_penaly_count) { //yieBݒΏۂ
			if(battle_config.agi_penaly_type == 1) //𗦂agi_penaly_num%
				flee = (flee * (100 - (target_count - (battle_config.agi_penaly_count - 1))*battle_config.agi_penaly_num))/100;
			else if(battle_config.agi_penaly_type == 2) //𗦂agi_penaly_num
				flee -= (target_count - (battle_config.agi_penaly_count - 1))*battle_config.agi_penaly_num;
			if(flee < 1) flee = 1; //𗦂͍Œł1
		}
	}
	hitrate=battle_get_hit(src) - flee + 80; //vZ

	type=0;	// normal
	div_ = 1; // single attack

	dex=battle_get_dex(src); //DEX
	luk=battle_get_luk(src); //LUK
	watk = battle_get_atk(src); //ATK
	watk_ = battle_get_atk_(src); //ATK

	if(skill_num==HW_MAGICCRASHER){			/* }WbNNbV[MATKŉ */
		damage = damage2 = battle_get_matk1(src); //damega,damega2oAbase_atk̎擾
	}else{
		damage = damage2 = battle_get_baseatk(&sd->bl); //damega,damega2oAbase_atk̎擾
	}
	atkmin = atkmin_ = dex; //ŒATKDEXŏH
	sd->state.arrow_atk = 0; //arrow_atk
	if(sd->equip_index[9] >= 0 && sd->inventory_data[sd->equip_index[9]])
		atkmin = atkmin*(80 + sd->inventory_data[sd->equip_index[9]]->wlv*20)/100;
	if(sd->equip_index[8] >= 0 && sd->inventory_data[sd->equip_index[8]])
		atkmin_ = atkmin_*(80 + sd->inventory_data[sd->equip_index[8]]->wlv*20)/100;
	if(sd->status.weapon == 11) { //킪|̏ꍇ
		atkmin = watk * ((atkmin<watk)? atkmin:watk)/100; //|pŒATKvZ
		flag=(flag&~BF_RANGEMASK)|BF_LONG; //UtOL
		if(sd->arrow_ele > 0) //Ȃ瑮̑ɕύX
			s_ele = sd->arrow_ele;
		sd->state.arrow_atk = 1; //arrow_atkL
	}

		// TCYC
		// yRR悵ĂāAōUꍇ͒^̃TCYC100ɂ
		// EF|p[tFNV,hCNC
	if((pc_isriding(sd) && (sd->status.weapon==4 || sd->status.weapon==5) && t_size==1) || skill_num == MO_EXTREMITYFIST) {	//yRR悵ĂāAŒ^U
		atkmax = watk;
		atkmax_ = watk_;
	} else {
		atkmax = (watk * sd->atkmods[ t_size ]) / 100;
		atkmin = (atkmin * sd->atkmods[ t_size ]) / 100;
		atkmax_ = (watk_ * sd->atkmods_[ t_size ]) / 100;
		atkmin_ = (atkmin_ * sd->atkmods[ t_size ]) / 100;
	}
	if( (sc_data != NULL && sc_data[SC_WEAPONPERFECTION].timer!=-1) || (sd->special_state.no_sizefix)) {	// EF|p[tFNV || hCNJ[h
		atkmax = watk;
		atkmax_ = watk_;
	}

	if(atkmin > atkmax && !(sd->state.arrow_atk)) atkmin = atkmax;	//|͍ŒႪꍇ
	if(atkmin_ > atkmax_) atkmin_ = atkmax_;

	if(sc_data != NULL && sc_data[SC_MAXIMIZEPOWER].timer!=-1 ){	// }LV}CYp[
		atkmin=atkmax;
		atkmin_=atkmax_;
	}

	//_uA^bN
	if(sd->weapontype1 == 0x01) {
		if(skill_num == 0 && skill_lv >= 0 && (skill = pc_checkskill(sd,TF_DOUBLE)) > 0)
			da = (rand()%100 < (skill*5)) ? 1:0;
	}

	//Oi
	if(skill_num == 0 && skill_lv >= 0 && (skill = pc_checkskill(sd,MO_TRIPLEATTACK)) > 0 && sd->status.weapon <= 16 && !sd->state.arrow_atk) {
			da = (rand()%100 < (30 - skill)) ? 2:0;
	}

	if(sd->double_rate > 0 && da == 0 && skill_num == 0 && skill_lv >= 0)
		da = (rand()%100 < sd->double_rate) ? 1:0;

 	// ߏ萸B{[iX
	if(sd->overrefine>0 )
		damage+=(rand()%sd->overrefine)+1;
	if(sd->overrefine_>0 )
		damage2+=(rand()%sd->overrefine_)+1;

	if(da == 0){ //_uA^bNĂȂ
		// NeBJvZ
		cri = battle_get_critical(src);

		if(sd->state.arrow_atk)
			cri += sd->arrow_cri;
		if(sd->status.weapon == 16)
				// J^[̏ꍇANeBJ{
			cri <<=1;
		cri -= battle_get_luk(target) * 3;
		if(t_sc_data != NULL && t_sc_data[SC_SLEEP].timer!=-1 )	// ̓NeBJ{
			cri <<=1;
		if(ac_flag) cri = 1000;

		if(skill_num == KN_AUTOCOUNTER) {
			if(!(battle_config.pc_auto_counter_type&1))
				cri = 1000;
			else
				cri <<= 1;
		}
		
		if(skill_num == SN_SHARPSHOOTING && rand()%100 < 50)
			cri = 1000;
	}

	if(tsd && tsd->critical_def)
		cri = cri * (100-tsd->critical_def) / 100;

	if(da == 0 && (skill_num==0 || skill_num == KN_AUTOCOUNTER || skill_num == SN_SHARPSHOOTING) && skill_lv >= 0 && //_uA^bNĂȂ
		(rand() % 1000) < cri) 	// iXL̏ꍇ͖j
	{
		damage += atkmax;
		damage2 += atkmax_;
		if(sd->atk_rate != 100) {
			damage = (damage * sd->atk_rate)/100;
			damage2 = (damage2 * sd->atk_rate)/100;
		}
		if(sd->state.arrow_atk)
			damage += sd->arrow_atk;
		type = 0x0a;

/*		if(def1 < 1000000) {
			if(sd->def_ratio_atk_ele & (1<<t_ele) || sd->def_ratio_atk_race & (1<<t_race)) {
				damage = (damage * (def1 + def2))/100;
				idef_flag = 1;
			}
			if(sd->def_ratio_atk_ele_ & (1<<t_ele) || sd->def_ratio_atk_race_ & (1<<t_race)) {
				damage2 = (damage2 * (def1 + def2))/100;
				idef_flag_ = 1;
			}
			if(t_mode & 0x20) {
				if(!idef_flag && sd->def_ratio_atk_race & (1<<10)) {
					damage = (damage * (def1 + def2))/100;
					idef_flag = 1;
				}
				if(!idef_flag_ && sd->def_ratio_atk_race_ & (1<<10)) {
					damage2 = (damage2 * (def1 + def2))/100;
					idef_flag_ = 1;
				}
			}
			else {
				if(!idef_flag && sd->def_ratio_atk_race & (1<<11)) {
					damage = (damage * (def1 + def2))/100;
					idef_flag = 1;
				}
				if(!idef_flag_ && sd->def_ratio_atk_race_ & (1<<11)) {
					damage2 = (damage2 * (def1 + def2))/100;
					idef_flag_ = 1;
				}
			}
		}*/
	}
	else {
		int vitbonusmax;

		if(atkmax > atkmin)
			damage += atkmin + rand() % (atkmax-atkmin + 1);
		else
			damage += atkmin ;
		if(atkmax_ > atkmin_)
			damage2 += atkmin_ + rand() % (atkmax_-atkmin_ + 1);
		else
			damage2 += atkmin_ ;
		if(sd->atk_rate != 100) {
			damage = (damage * sd->atk_rate)/100;
			damage2 = (damage2 * sd->atk_rate)/100;
		}

		if(sd->state.arrow_atk) {
			if(sd->arrow_atk > 0)
				damage += rand()%(sd->arrow_atk+1);
			hitrate += sd->arrow_hit;
		}

		if(skill_num != MO_INVESTIGATE && def1 < 1000000) {
			if(sd->def_ratio_atk_ele & (1<<t_ele) || sd->def_ratio_atk_race & (1<<t_race)) {
				damage = (damage * (def1 + def2))/100;
				idef_flag = 1;
			}
			if(sd->def_ratio_atk_ele_ & (1<<t_ele) || sd->def_ratio_atk_race_ & (1<<t_race)) {
				damage2 = (damage2 * (def1 + def2))/100;
				idef_flag_ = 1;
			}
			if(t_mode & 0x20) {
				if(!idef_flag && sd->def_ratio_atk_race & (1<<10)) {
					damage = (damage * (def1 + def2))/100;
					idef_flag = 1;
				}
				if(!idef_flag_ && sd->def_ratio_atk_race_ & (1<<10)) {
					damage2 = (damage2 * (def1 + def2))/100;
					idef_flag_ = 1;
				}
			}
			else {
				if(!idef_flag && sd->def_ratio_atk_race & (1<<11)) {
					damage = (damage * (def1 + def2))/100;
					idef_flag = 1;
				}
				if(!idef_flag_ && sd->def_ratio_atk_race_ & (1<<11)) {
					damage2 = (damage2 * (def1 + def2))/100;
					idef_flag_ = 1;
				}
			}
		}

		// XLCPiU͔{nj
		// I[o[gXg(+5% ` +25%),UnXL̏ꍇŕ␳
		// obV,}OiuCN,
		// {[OobV,XsAu[,ufBbVXsA,XsAX^bu,
		// }[iCg,J[g{[V
		// _uXgCtBO,A[V[,`[WA[,
		// \jbNu[
		if(sc_data){ //Ԉُ풆̃_[Wǉ
			if(sc_data[SC_OVERTHRUST].timer!=-1){	// I[o[gXg
				damage += damage*(5*sc_data[SC_OVERTHRUST].val1)/100;
				damage2 += damage2*(5*sc_data[SC_OVERTHRUST].val1)/100;
			}
			if(sc_data[SC_TRUESIGHT].timer!=-1){	// gD[TCg
				damage += damage*(2*sc_data[SC_TRUESIGHT].val1)/100;
				damage2 += damage2*(2*sc_data[SC_TRUESIGHT].val1)/100;
			}
			if(sc_data[SC_BERSERK].timer!=-1){	// o[T[N
				damage += damage*50/100;
				damage2 += damage2*50/100;
			}
		}

		if(skill_num>0){
			int i;
			if( (i=skill_get_pl(skill_num))>0 )
				s_ele=s_ele_=i;

			flag=(flag&~BF_SKILLMASK)|BF_SKILL;
			switch( skill_num ){
			case SM_BASH:		// obV
				damage = damage*(100+ 30*skill_lv)/100;
				damage2 = damage2*(100+ 30*skill_lv)/100;
				hitrate = (hitrate*(100+5*skill_lv))/100;
				break;
			case SM_MAGNUM:		// }OiuCN
				damage = damage*(5*skill_lv +(wflag)?65:115 )/100;
				damage2 = damage2*(5*skill_lv +(wflag)?65:115 )/100;
				break;
			case MC_MAMMONITE:	// }[iCg
				damage = damage*(100+ 50*skill_lv)/100;
				damage2 = damage2*(100+ 50*skill_lv)/100;
				break;
			case AC_DOUBLE:	// _uXgCtBO
				if(!sd->state.arrow_atk && sd->arrow_atk > 0) {
					int arr = rand()%(sd->arrow_atk+1);
					damage += arr;
					damage2 += arr;
				}
				damage = damage*(180+ 20*skill_lv)/100;
				damage2 = damage2*(180+ 20*skill_lv)/100;
				div_=2;
				if(sd->arrow_ele > 0) {
					s_ele = sd->arrow_ele;
					s_ele_ = sd->arrow_ele;
				}
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				sd->state.arrow_atk = 1;
				break;
			case AC_SHOWER:	// A[V[
				if(!sd->state.arrow_atk && sd->arrow_atk > 0) {
					int arr = rand()%(sd->arrow_atk+1);
					damage += arr;
					damage2 += arr;
				}
				damage = damage*(75 + 5*skill_lv)/100;
				damage2 = damage2*(75 + 5*skill_lv)/100;
				if(sd->arrow_ele > 0) {
					s_ele = sd->arrow_ele;
					s_ele_ = sd->arrow_ele;
				}
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				sd->state.arrow_atk = 1;
				break;
			case AC_CHARGEARROW:	// `[WA[
				if(!sd->state.arrow_atk && sd->arrow_atk > 0) {
					int arr = rand()%(sd->arrow_atk+1);
					damage += arr;
					damage2 += arr;
				}
				damage = damage*150/100;
				damage2 = damage2*150/100;
				if(sd->arrow_ele > 0) {
					s_ele = sd->arrow_ele;
					s_ele_ = sd->arrow_ele;
				}
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				sd->state.arrow_atk = 1;
				break;
			case KN_PIERCE:	// sA[X
				damage = damage*(100+ 10*skill_lv)/100;
				damage2 = damage2*(100+ 10*skill_lv)/100;
				hitrate=hitrate*(100+5*skill_lv)/100;
				div_=t_size+1;
				damage*=div_;
				damage2*=div_;
				break;
			case KN_SPEARSTAB:	// XsAX^u
				damage = damage*(100+ 15*skill_lv)/100;
				damage2 = damage2*(100+ 15*skill_lv)/100;
				break;
			case KN_SPEARBOOMERANG:	// XsAu[
				damage = damage*(100+ 50*skill_lv)/100;
				damage2 = damage2*(100+ 50*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case KN_BRANDISHSPEAR: // ufBbVXsA
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				if(skill_lv>3 && wflag==1) damage3+=damage/2;
				if(skill_lv>6 && wflag==1) damage3+=damage/4;
				if(skill_lv>9 && wflag==1) damage3+=damage/8;
				if(skill_lv>6 && wflag==2) damage3+=damage/2;
				if(skill_lv>9 && wflag==2) damage3+=damage/4;
				if(skill_lv>9 && wflag==3) damage3+=damage/2;
				damage +=damage3;
				if(skill_lv>3 && wflag==1) damage4+=damage2/2;
				if(skill_lv>6 && wflag==1) damage4+=damage2/4;
				if(skill_lv>9 && wflag==1) damage4+=damage2/8;
				if(skill_lv>6 && wflag==2) damage4+=damage2/2;
				if(skill_lv>9 && wflag==2) damage4+=damage2/4;
				if(skill_lv>9 && wflag==3) damage4+=damage2/2;
				damage2 +=damage4;
				blewcount=0;
				break;
			case KN_BOWLINGBASH:	// {EOobV
				damage = damage*(100+ 50*skill_lv)/100;
				damage2 = damage2*(100+ 50*skill_lv)/100;
				blewcount=0;
				break;
			case KN_AUTOCOUNTER:
				if(battle_config.pc_auto_counter_type&1)
					hitrate += 20;
				else
					hitrate = 1000000;
				flag=(flag&~BF_SKILLMASK)|BF_NORMAL;
				break;
			case AS_SONICBLOW:	// \jbNuE
				damage = damage*(300+ 50*skill_lv)/100;
				damage2 = damage2*(300+ 50*skill_lv)/100;
				div_=8;
				break;
			case TF_SPRINKLESAND:	// ܂
				damage = damage*125/100;
				damage2 = damage2*125/100;
				break;
			case MC_CARTREVOLUTION:	// J[g{[V
				if(sd->cart_max_weight > 0 && sd->cart_weight > 0) {
					damage = (damage*(150 + pc_checkskill(sd,BS_WEAPONRESEARCH) + (sd->cart_weight*100/sd->cart_max_weight) ) )/100;
					damage2 = (damage2*(150 + pc_checkskill(sd,BS_WEAPONRESEARCH) + (sd->cart_weight*100/sd->cart_max_weight) ) )/100;
				}
				else {
					damage = (damage*150)/100;
					damage2 = (damage2*150)/100;
				}
				break;
			// ȉMOB
			case NPC_COMBOATTACK:	// iU
				div_=skill_get_num(skill_num,skill_lv);
				damage *= div_;
				damage2 *= div_;
				break;
			case NPC_RANDOMATTACK:	// _ATKU
				damage = damage*(50+rand()%150)/100;
				damage2 = damage2*(50+rand()%150)/100;
				break;
			// UiKj
			case NPC_WATERATTACK:
			case NPC_GROUNDATTACK:
			case NPC_FIREATTACK:
			case NPC_WINDATTACK:
			case NPC_POISONATTACK:
			case NPC_HOLYATTACK:
			case NPC_DARKNESSATTACK:
			case NPC_TELEKINESISATTACK:
				damage = damage*(100+25*skill_lv)/100;
				damage2 = damage2*(100+25*skill_lv)/100;
				break;
			case NPC_GUIDEDATTACK:
				hitrate = 1000000;
				break;
			case NPC_RANGEATTACK:
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				break;
			case NPC_PIERCINGATT:
				flag=(flag&~BF_RANGEMASK)|BF_SHORT;
				break;
			case RG_BACKSTAP:	// obNX^u
				damage = damage*(300+ 40*skill_lv)/100;
				damage2 = damage2*(300+ 40*skill_lv)/100;
				hitrate = 1000000;
				break;
			case RG_RAID:	// TvCYA^bN
				damage = damage*(100+ 40*skill_lv)/100;
				damage2 = damage2*(100+ 40*skill_lv)/100;
				break;
			case RG_INTIMIDATE:	// CeB~fCg
				damage = damage*(100+ 30*skill_lv)/100;
				damage2 = damage2*(100+ 30*skill_lv)/100;
				break;
			case CR_SHIELDCHARGE:	// V[h`[W
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_SHORT;
				s_ele = 0;
				break;
			case CR_SHIELDBOOMERANG:	// V[hu[
				damage = damage*(100+ 30*skill_lv)/100;
				damage2 = damage2*(100+ 30*skill_lv)/100;
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				s_ele = 0;
				break;
			case CR_HOLYCROSS:	// z[[NX
				damage = damage*(100+ 35*skill_lv)/100;
				damage2 = damage2*(100+ 35*skill_lv)/100;
				div_=2;
				break;
			case CR_GRANDCROSS:
				hitrate= 1000000;
				break;
			case AM_DEMONSTRATION:	// fXg[V
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				break;
			case AM_ACIDTERROR:	// AVbhe[
				damage = damage*(100+ 40*skill_lv)/100;
				damage2 = damage2*(100+ 40*skill_lv)/100;
				break;
			case MO_FINGEROFFENSIVE:	//we
				if(battle_config.finger_offensive_type == 0) {
					damage = damage * (100 + 50 * skill_lv) / 100 * sd->spiritball_old;
					damage2 = damage2 * (100 + 50 * skill_lv) / 100 * sd->spiritball_old;
					div_ = sd->spiritball_old;
				}
				else {
					damage = damage * (100 + 50 * skill_lv) / 100;
					damage2 = damage2 * (100 + 50 * skill_lv) / 100;
					div_ = 1;
				}
				break;
			case MO_INVESTIGATE:	//  
				if(def1 < 1000000) {
					damage = damage*(100+ 75*skill_lv)/100 * (def1 + def2)/100;
					damage2 = damage2*(100+ 75*skill_lv)/100 * (def1 + def2)/100;
				}
				hitrate = 1000000;
				s_ele = 0;
				s_ele_ = 0;
				break;
			case MO_EXTREMITYFIST:	// CeP
				damage = damage * (8 + ((sd->status.sp)/10)) + 250 + (skill_lv * 150);
				damage2 = damage2 * (8 + ((sd->status.sp)/10)) + 250 + (skill_lv * 150);
				sd->status.sp = 0;
				clif_updatestatus(sd,SP_SP);
				hitrate = 1000000;
				s_ele = 0;
				s_ele_ = 0;
				break;
			case MO_CHAINCOMBO:	// Aŏ
				damage = damage*(150+ 50*skill_lv)/100;
				damage2 = damage2*(150+ 50*skill_lv)/100;
				div_=4;
				break;
			case MO_COMBOFINISH:	// җ
				damage = damage*(240+ 60*skill_lv)/100;
				damage2 = damage2*(240+ 60*skill_lv)/100;
				break;
			case BA_MUSICALSTRIKE:	// ~[WJXgCN
				if(!sd->state.arrow_atk && sd->arrow_atk > 0) {
					int arr = rand()%(sd->arrow_atk+1);
					damage += arr;
					damage2 += arr;
				}
				damage = damage*(100+ 50 * skill_lv)/100;
				damage2 = damage2*(100+ 50 * skill_lv)/100;
				if(sd->arrow_ele > 0) {
					s_ele = sd->arrow_ele;
					s_ele_ = sd->arrow_ele;
				}
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				sd->state.arrow_atk = 1;
				break;
			case DC_THROWARROW:	// 
				if(!sd->state.arrow_atk && sd->arrow_atk > 0) {
					int arr = rand()%(sd->arrow_atk+1);
					damage += arr;
					damage2 += arr;
				}
				damage = damage*(100+ 50 * skill_lv)/100;
				damage2 = damage2*(100+ 50 * skill_lv)/100;
				if(sd->arrow_ele > 0) {
					s_ele = sd->arrow_ele;
					s_ele_ = sd->arrow_ele;
				}
				flag=(flag&~BF_RANGEMASK)|BF_LONG;
				sd->state.arrow_atk = 1;
				break;
			case CH_TIGERFIST:	// Ռ
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				break;
			case CH_CHAINCRUSH:	// A
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				div_=skill_get_num(skill_num,skill_lv);
				break;
			case CH_PALMSTRIKE:	// ҌՍdhR
				damage = damage*(50+ 100*skill_lv)/100;
				damage2 = damage2*(50+ 100*skill_lv)/100;
				break;
			case LK_SPIRALPIERCE:			/* XpCsA[X */
				damage = damage*(100+ 50*skill_lv)/100; //ʂȂ̂œK
				damage2 = damage2*(100+ 50*skill_lv)/100; //ʂȂ̂œK
				div_=5;
				if(tsd)
					tsd->canmove_tick = gettick() + 1000;
				else if(tmd)
					tmd->canmove_tick = gettick() + 1000;
				break;
			case LK_HEADCRUSH:				/* wbhNbV */
				damage = damage*(100+ 20*skill_lv)/100;
				damage2 = damage2*(100+ 20*skill_lv)/100;
				break;
			case LK_JOINTBEAT:				/* WCgr[g */
				damage = damage*(50+ 10*skill_lv)/100;
				damage2 = damage2*(50+ 10*skill_lv)/100;
				break;
			case ASC_METEORASSAULT:			/* eIATg */
				damage = damage*(40+ 40*skill_lv)/100;
				damage2 = damage2*(40+ 40*skill_lv)/100;
				break;
			case SN_SHARPSHOOTING:			/* V[vV[eBO */
				damage += damage*(30*skill_lv)/100;
				damage2 += damage2*(30*skill_lv)/100;
				break;
			case CG_ARROWVULCAN:			/* A[oJ */
				damage = damage*(160+40*skill_lv)/100;
				damage2 = damage2*(160+40*skill_lv)/100;
				div_=9;
				break;
			}
		}
		if(da == 2) { //OiĂ邩
			type = 0x08;
			div_ = 255;	//OipɁc
			damage = damage * (100 + 20 * pc_checkskill(sd, MO_TRIPLEATTACK)) / 100;
		}

		if( skill_num!=NPC_CRITICALSLASH ){
			//  ۂ̖h͂ɂ_[W̌
			// fBoCveNVił̂ȁHj
			if ( skill_num != MO_INVESTIGATE && skill_num != MO_EXTREMITYFIST && skill_num != KN_AUTOCOUNTER && def1 < 1000000) {	//DEF, VIT
				int t_def;
				target_count = 1 + battle_counttargeted(target,src,battle_config.vit_penaly_count_lv);
				if(battle_config.vit_penaly_type > 0) {
					if(target_count >= battle_config.vit_penaly_count) {
						if(battle_config.vit_penaly_type == 1) {
							def1 = (def1 * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
							def2 = (def2 * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
							t_vit = (t_vit * (100 - (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num))/100;
						}
						else if(battle_config.vit_penaly_type == 2) {
							def1 -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
							def2 -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
							t_vit -= (target_count - (battle_config.vit_penaly_count - 1))*battle_config.vit_penaly_num;
						}
						if(def1 < 0) def1 = 0;
						if(def2 < 1) def2 = 1;
						if(t_vit < 1) t_vit = 1;
					}
				}
				t_def = def2*8/10;
				vitbonusmax = (t_vit/20)*(t_vit/20)-1;
				if(sd->ignore_def_ele & (1<<t_ele) || sd->ignore_def_race & (1<<t_race))
					idef_flag = 1;
				if(sd->ignore_def_ele_ & (1<<t_ele) || sd->ignore_def_race_ & (1<<t_race))
					idef_flag_ = 1;
				if(t_mode & 0x20) {
					if(sd->ignore_def_race & (1<<10))
						idef_flag = 1;
					if(sd->ignore_def_race_ & (1<<10))
						idef_flag_ = 1;
				}
				else {
					if(sd->ignore_def_race & (1<<11))
						idef_flag = 1;
					if(sd->ignore_def_race_ & (1<<11))
						idef_flag_ = 1;
				}

				if(!idef_flag){
					if(battle_config.player_defense_type) {
						damage = damage - (def1 * battle_config.player_defense_type) - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
					}
					else{
						damage = damage * (100 - def1) /100 - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
					}
				}
				if(!idef_flag_){
					if(battle_config.player_defense_type) {
						damage2 = damage2 - (def1 * battle_config.player_defense_type) - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
					}
					else{
						damage2 = damage2 * (100 - def1) /100 - t_def - ((vitbonusmax < 1)?0: rand()%(vitbonusmax+1) );
					}
				}
			}
		}
	}
	// B_[W̒ǉ
	if( skill_num != MO_INVESTIGATE && skill_num != MO_EXTREMITYFIST) {			//DEF, VIT
		damage += battle_get_atk2(src);
		damage2 += battle_get_atk_2(src);
	}
	if(skill_num == CR_SHIELDBOOMERANG) {
		if(sd->equip_index[8] >= 0) {
			int index = sd->equip_index[8];
			if(sd->inventory_data[index] && sd->inventory_data[index]->type == 5) {
				damage += sd->inventory_data[index]->weight/10;
				damage += sd->status.inventory[index].refine * pc_getrefinebonus(0,1);
			}
		}
	}
	if(skill_num == LK_SPIRALPIERCE) {			/* XpCsA[X */
		if(sd->equip_index[9] >= 0) {	//dʂŒǉ_[W炵̂ŃV[hu[Qlɒǉ
			int index = sd->equip_index[9];
			if(sd->inventory_data[index] && sd->inventory_data[index]->type == 4) {
				damage += sd->inventory_data[index]->weight/10;
				damage += sd->status.inventory[index].refine * pc_getrefinebonus(0,1);
			}
		}
	}

	// 0ꍇ1ɕ␳
	if(damage<1) damage=1;
	if(damage2<1) damage2=1;

	// XLCQiCnj
	// C_[W(Ê) \jbNu[͕ʏi1ɕt1/8K)
	if( skill_num != MO_INVESTIGATE && skill_num != MO_EXTREMITYFIST && skill_num != CR_GRANDCROSS) {			//C_[W
		damage = battle_addmastery(sd,target,damage,0);
		damage2 = battle_addmastery(sd,target,damage2,1);
	}

	if(sd->perfect_hit > 0) {
		if(rand()%100 < sd->perfect_hit)
			hitrate = 1000000;
	}

	// C
	hitrate = (hitrate<5)?5:hitrate;
	if(	hitrate < 1000000 && // KU
		(t_sc_data != NULL && (t_sc_data[SC_SLEEP].timer!=-1 ||	// ͕K
		t_sc_data[SC_STAN].timer!=-1 ||		// X^͕K
		t_sc_data[SC_FREEZE].timer!=-1 || (t_sc_data[SC_STONE].timer!=-1 && t_sc_data[SC_STONE].val2==0) ) ) )	// ͕K
		hitrate = 1000000;
	if(type == 0 && rand()%100 >= hitrate) {
		damage = damage2 = 0;
		dmg_lv = ATK_FLEE;
	} else {
		dmg_lv = ATK_DEF;
	}
	// XLCRi팤j
	if( (skill=pc_checkskill(sd,BS_WEAPONRESEARCH)) > 0) {
		damage+= skill*2;
		damage2+= skill*2;
	}
//XLɂ_[W␳܂

//J[hɂ_[Wǉ
	cardfix=100;
	if(!sd->state.arrow_atk) { //|ȊO
		if(!battle_config.left_cardfix_to_right) { //J[h␳ݒ薳
			cardfix=cardfix*(100+sd->addrace[t_race])/100;	// 푰ɂ_[WC
			cardfix=cardfix*(100+sd->addele[t_ele])/100;	// ɂ_[WC
			cardfix=cardfix*(100+sd->addsize[t_size])/100;	// TCYɂ_[WC
		}
		else {
			cardfix=cardfix*(100+sd->addrace[t_race]+sd->addrace_[t_race])/100;	// 푰ɂ_[WC(ɂǉ)
			cardfix=cardfix*(100+sd->addele[t_ele]+sd->addele_[t_ele])/100;	// ɂ_[WC(ɂǉ)
			cardfix=cardfix*(100+sd->addsize[t_size]+sd->addsize_[t_size])/100;	// TCYɂ_[WC(ɂǉ)
		}
	}
	else { //|
		cardfix=cardfix*(100+sd->addrace[t_race]+sd->arrow_addrace[t_race])/100;	// 푰ɂ_[WC(|ɂǉ)
		cardfix=cardfix*(100+sd->addele[t_ele]+sd->arrow_addele[t_ele])/100;	// ɂ_[WC(|ɂǉ)
		cardfix=cardfix*(100+sd->addsize[t_size]+sd->arrow_addsize[t_size])/100;	// TCYɂ_[WC(|ɂǉ)
	}
	if(t_mode & 0x20) { //{X
		if(!sd->state.arrow_atk) { //|UȊOȂ
			if(!battle_config.left_cardfix_to_right) //J[h␳ݒ薳
				cardfix=cardfix*(100+sd->addrace[10])/100; //{XX^[ɒǉ_[W
			else //J[h␳ݒ肠
				cardfix=cardfix*(100+sd->addrace[10]+sd->addrace_[10])/100; //{XX^[ɒǉ_[W(ɂǉ)
		}
		else //|U
			cardfix=cardfix*(100+sd->addrace[10]+sd->arrow_addrace[10])/100; //{XX^[ɒǉ_[W(|ɂǉ)
	}
	else { //{XȂ
		if(!sd->state.arrow_atk) { //|UȊO
			if(!battle_config.left_cardfix_to_right) //J[h␳ݒ薳
				cardfix=cardfix*(100+sd->addrace[11])/100; //{XȊOX^[ɒǉ_[W
			else //J[h␳ݒ肠
				cardfix=cardfix*(100+sd->addrace[11]+sd->addrace_[11])/100; //{XȊOX^[ɒǉ_[W(ɂǉ)
	}
		else
			cardfix=cardfix*(100+sd->addrace[11]+sd->arrow_addrace[11])/100; //{XȊOX^[ɒǉ_[W(|ɂǉ)
	}
	//Classp␳(̓L{SpH)
	t_class = battle_get_class(target);
	for(i=0;i<sd->add_damage_class_count;i++) {
		if(sd->add_damage_classid[i] == t_class) {
			cardfix=cardfix*(100+sd->add_damage_classrate[i])/100;
			break;
		}
	}
	if(skill_num != CR_GRANDCROSS || !battle_config.gx_cardfix)
		damage=damage*cardfix/100; //J[h␳ɂ_[W
//J[hɂ_[W܂

//J[hɂ_[Wǉ()
	cardfix=100;
	if(!battle_config.left_cardfix_to_right) {  //J[h␳ݒ薳
		cardfix=cardfix*(100+sd->addrace_[t_race])/100;	// 푰ɂ_[WC
		cardfix=cardfix*(100+sd->addele_[t_ele])/100;	//  ɂ_[WC
		cardfix=cardfix*(100+sd->addsize_[t_size])/100;	// TCYɂ_[WC
		if(t_mode & 0x20) //{X
			cardfix=cardfix*(100+sd->addrace_[10])/100; //{XX^[ɒǉ_[W
		else
			cardfix=cardfix*(100+sd->addrace_[11])/100; //{XȊOX^[ɒǉ_[W
	}
	//Classp␳(̓L{SpH)
	for(i=0;i<sd->add_damage_class_count_;i++) {
		if(sd->add_damage_classid_[i] == t_class) {
			cardfix=cardfix*(100+sd->add_damage_classrate_[i])/100;
			break;
		}
	}
	if(skill_num != CR_GRANDCROSS) damage2=damage2*cardfix/100; //J[h␳ɂ鍶_[W
//J[hɂ_[W()܂

//J[hɂ_[W
	if(tsd){ //ΏۂPC̏ꍇ
		cardfix=100;
		cardfix=cardfix*(100-tsd->subrace[s_race])/100;	// 푰ɂ_[Wϐ
		cardfix=cardfix*(100-tsd->subele[s_ele])/100;	// ɂ_[Wϐ
		if(battle_get_mode(src) & 0x20)
			cardfix=cardfix*(100-tsd->subrace[10])/100; //{X̍U̓_[W
		else
			cardfix=cardfix*(100-tsd->subrace[11])/100; //{XȊO̍U̓_[W
		//Classp␳(̓L{SpH)
		for(i=0;i<tsd->add_def_class_count;i++) {
			if(tsd->add_def_classid[i] == sd->status.class) {
				cardfix=cardfix*(100-tsd->add_def_classrate[i])/100;
				break;
			}
		}
		if(flag&BF_LONG)
			cardfix=cardfix*(100-tsd->long_attack_def_rate)/100; //U̓_[W(zCƂ)
		if(flag&BF_SHORT)
			cardfix=cardfix*(100-tsd->near_attack_def_rate)/100; //ߋU̓_[W(YH)
		damage=damage*cardfix/100; //J[h␳ɂ_[W
		damage2=damage2*cardfix/100; //J[h␳ɂ鍶_[W
	}
//J[hɂ_[W܂

//ΏۂɃXe[^Xُ킪ꍇ̃_[WZ
	if(t_sc_data) {
		cardfix=100;
		if(t_sc_data[SC_DEFENDER].timer != -1 && flag&BF_LONG) //fBtF_[ԂŉU
			cardfix=cardfix*(100-t_sc_data[SC_DEFENDER].val2)/100; //fBtF_[ɂ錸
		if(cardfix != 100) {
			damage=damage*cardfix/100; //fBtF_[␳ɂ_[W
			damage2=damage2*cardfix/100; //fBtF_[␳ɂ鍶_[W
		}
		if(t_sc_data[SC_ASSUMPTIO].timer != -1){ //AXveBI
			if(!map[target->m].flag.pvp){
				damage=damage/3;
				damage2=damage2/3;
			}else{
				damage=damage/2;
				damage2=damage2/2;
			}
		}
	}
//ΏۂɃXe[^Xُ킪ꍇ̃_[WZ܂

	if(damage < 0) damage = 0;
	if(damage2 < 0) damage2 = 0;

	//  ̓Kp
		damage=battle_attr_fix(damage,s_ele, battle_get_element(target) );
		damage2=battle_attr_fix(damage2,s_ele_, battle_get_element(target) );

	// ̂AC̓Kp
	damage += sd->star;
	damage2 += sd->star_;
	damage += sd->spiritball*3;
	damage2 += sd->spiritball*3;

	if(sc_data && sc_data[SC_AURABLADE].timer!=-1){	/* I[u[h K */
		damage += sc_data[SC_AURABLADE].val1 * 10;
		damage2 += sc_data[SC_AURABLADE].val1 * 10;
	}
	if(skill_num==PA_PRESSURE){ /* vbV[ K? */
		damage = 700+100*skill_lv;
		damage2 = 700+100*skill_lv;
	}

	// >񓁗̍E_[WvZNĂꂥI
	// >map_session_data ɍ_[W(atk,atk2)ǉ
	// >pc_calcstatus()łׂȁH
	// map_session_data ɍ蕐(atk,atk2,ele,star,atkmods)ǉ
	// pc_calcstatus()Ńf[^͂Ă܂

	//̂ݕ푕
	if(sd->weapontype1 == 0 && sd->weapontype2 > 0) {
		damage = damage2;
		damage2 = 0;
	}
	// EAC̓Kp
	if(sd->status.weapon > 16) {// 񓁗?
		int dmg = damage, dmg2 = damage2;
		// EC(60% ` 100%) ES
		skill = pc_checkskill(sd,AS_RIGHT);
		damage = damage * (50 + (skill * 10))/100;
		if(dmg > 0 && damage < 1) damage = 1;
		// C(40% ` 80%) S
		skill = pc_checkskill(sd,AS_LEFT);
		damage2 = damage2 * (30 + (skill * 10))/100;
		if(dmg2 > 0 && damage2 < 1) damage2 = 1;
	}
	else //񓁗łȂ΍_[W0
		damage2 = 0;

		// E,Ẑ
	if(da == 1) { //_uA^bNĂ邩
		div_ = 2;
		damage += damage;
		type = 0x08;
	}

	if(sd->status.weapon == 16) {
		// J^[ǌ_[W
		skill = pc_checkskill(sd,TF_DOUBLE);
		damage2 = damage * (1 + (skill * 2))/100;
		if(damage > 0 && damage2 < 1) damage2 = 1;
	}

	// CxiC
	if(skill_num==TF_POISON){
		damage = battle_attr_fix(damage + 15*skill_lv, s_ele, battle_get_element(target) );
	}
	if(skill_num==MC_CARTREVOLUTION){
		damage = battle_attr_fix(damage, 0, battle_get_element(target) );
	}

	// S̔
	if(skill_num == 0 && skill_lv >= 0 && tsd!=NULL && div_ < 255 && rand()%1000 < battle_get_flee2(target) ){
		damage=damage2=0;
		type=0x0b;
		dmg_lv = ATK_LUCKY;
	}

	// ΏۂSݒ肪ONȂ
	if(battle_config.enemy_perfect_flee) {
		if(skill_num == 0 && skill_lv >= 0 && tmd!=NULL && div_ < 255 && rand()%1000 < battle_get_flee2(target) ) {
			damage=damage2=0;
			type=0x0b;
			dmg_lv = ATK_LUCKY;
		}
	}

	//MobModeɊ拭tOĂƂ̏
	if(t_mode&0x40){
		if(damage > 0)
			damage = 1;
		if(damage2 > 0)
			damage2 = 1;
	}

	//bNoWeaponDamage(ݒACeH)ŃOhNXȂꍇ̓_[W0
	if( tsd && tsd->special_state.no_weapon_damage && skill_num != CR_GRANDCROSS)
		damage = damage2 = 0;

	if(skill_num != CR_GRANDCROSS && (damage > 0 || damage2 > 0) ) {
		if(damage2<1)		// _[WŏIC
			damage=battle_calc_damage(src,target,damage,div_,skill_num,skill_lv,flag);
		else if(damage<1)	// E肪~XH
			damage2=battle_calc_damage(src,target,damage2,div_,skill_num,skill_lv,flag);
		else {	//  /J^[̏ꍇ͂ƌvZ₱
			int d1=damage+damage2,d2=damage2;
			damage=battle_calc_damage(src,target,damage+damage2,div_,skill_num,skill_lv,flag);
			damage2=(d2*100/d1)*damage/100;
			if(damage > 1 && damage2 < 1) damage2=1;
			damage-=damage2;
		}
	}

	wd.damage=damage;
	wd.damage2=damage2;
	wd.type=type;
	wd.div_=div_;
	wd.amotion=battle_get_amotion(src);
	if(skill_num == KN_AUTOCOUNTER)
		wd.amotion >>= 1;
	wd.dmotion=battle_get_dmotion(target);
	wd.blewcount=blewcount;
	wd.flag=flag;
	wd.dmg_lv=dmg_lv;

	return wd;
}

/*==========================================
 * _[WvZ
 *------------------------------------------
 */
struct Damage battle_calc_weapon_attack(
	struct block_list *src,struct block_list *target,int skill_num,int skill_lv,int wflag)
{
	struct Damage wd;

	if( src == NULL || target == NULL ){
		printf("battle_calc_weapon_attack nullpo\n");
		memset(&wd,0,sizeof(wd));
		return wd;
	}

	if(target->type == BL_PET)
		memset(&wd,0,sizeof(wd));
	else if(src->type == BL_PC)
		wd = battle_calc_pc_weapon_attack(src,target,skill_num,skill_lv,wflag);
	else if(src->type == BL_MOB)
		wd = battle_calc_mob_weapon_attack(src,target,skill_num,skill_lv,wflag);
	else if(src->type == BL_PET)
		wd = battle_calc_pet_weapon_attack(src,target,skill_num,skill_lv,wflag);
	else
		memset(&wd,0,sizeof(wd));

	return wd;
}

/*==========================================
 * @_[WvZ
 *------------------------------------------
 */
struct Damage battle_calc_magic_attack(
	struct block_list *bl,struct block_list *target,int skill_num,int skill_lv,int flag)
{
	int mdef1=battle_get_mdef(target);
	int mdef2=battle_get_mdef2(target);
	int matk1,matk2,damage=0,div_=1,blewcount=skill_get_blewcount(skill_num,skill_lv);
	struct Damage md;
	int aflag;
	int normalmagic_flag=1;
	int ele=0,race=7,t_ele=0,t_race=7,t_mode = 0,cardfix,t_class,i;
	struct map_session_data *sd=NULL,*tsd=NULL;
	struct mob_data *tmd = NULL;

	if( bl == NULL || target == NULL ){
		printf("battle_calc_magic_attack nullpo\n");
		memset(&md,0,sizeof(md));
		return md;
	}

	if(target->type == BL_PET) {
		memset(&md,0,sizeof(md));
		return md;
	}

	matk1=battle_get_matk1(bl);
	matk2=battle_get_matk2(bl);
	ele = skill_get_pl(skill_num);
	race = battle_get_race(bl);
	t_ele = battle_get_elem_type(target);
	t_race = battle_get_race(target);
	t_mode = battle_get_mode(target);

#define MATK_FIX( a,b ) { matk1=matk1*(a)/(b); matk2=matk2*(a)/(b); }
	
	if( bl->type==BL_PC && (sd=(struct map_session_data *)bl) ){
		sd->state.attack_type = BF_MAGIC;
		if(sd->matk_rate != 100)
			MATK_FIX(sd->matk_rate,100);
		sd->state.arrow_atk = 0;
	}
	if( target->type==BL_PC )
		tsd=(struct map_session_data *)target;
	else if( target->type==BL_MOB )
		tmd=(struct mob_data *)target;

	aflag=BF_MAGIC|BF_LONG|BF_SKILL;
	
	if(skill_num > 0){
		switch(skill_num){	// {_[WvZ(XLƂɏ)
					// q[or
		case AL_HEAL:
		case PR_BENEDICTIO:
			damage = skill_calc_heal(bl,skill_lv)/2;
			normalmagic_flag=0;
			break;
		case PR_ASPERSIO:		/* AXyVI */
			damage = 40; //Œ_[W
			normalmagic_flag=0;
			break;
		case PR_SANCTUARY:	// TN`A
			damage = (skill_lv>6)?388:skill_lv*50;
			normalmagic_flag=0;
			blewcount|=0x10000;
			break;
		case ALL_RESURRECTION:
		case PR_TURNUNDEAD:	// UUNVƃ^[Afbh
			if(target->type != BL_PC && battle_check_undead(t_race,t_ele)){
				int hp, mhp, thres;
				hp = battle_get_hp(target);
				mhp = battle_get_max_hp(target);
				thres = (skill_lv * 20) + battle_get_luk(bl)+
						battle_get_int(bl) + battle_get_lv(bl)+
						((200 - hp * 200 / mhp));
				if(thres > 700) thres = 700;
//				if(battle_config.battle_log)
//					printf("^[AfbhI m%d (番)\n", thres);
				if(rand()%1000 < thres && !(t_mode&0x20))	// 
					damage = hp;
				else					// s
					damage = battle_get_lv(bl) + battle_get_int(bl) + skill_lv * 10;
			}
			normalmagic_flag=0;
			break;

		case MG_NAPALMBEAT:	// ip[r[giUvZ݁j
			MATK_FIX(70+ skill_lv*10,100);
			if(flag>0){
				MATK_FIX(1,flag);
			}else {
				if(battle_config.error_log)
					printf("battle_calc_magic_attack(): napam enemy count=0 !\n");
			}
			break;
		case MG_FIREBALL:	// t@C[{[
			{
				const int drate[]={100,90,70};
				if(flag>2)
					matk1=matk2=0;
				else
					MATK_FIX( (95+skill_lv*5)*drate[flag] ,10000 );
			}
			break;
		case MG_FIREWALL:	// t@C[EH[
/*
			if( (t_ele!=3 && !battle_check_undead(t_race,t_ele)) || target->type==BL_PC ) //PC͉ΑłԁH_[W󂯂H
				blewcount |= 0x10000;
			else
				blewcount = 0;
*/
			if((t_ele==3 || battle_check_undead(t_race,t_ele)) && target->type!=BL_PC)
				blewcount = 0;
			else
				blewcount |= 0x10000;
			MATK_FIX( 1,2 );
			break;
		case MG_THUNDERSTORM:	// T_[Xg[
			MATK_FIX( 80,100 );
			break;
		case MG_FROSTDIVER:	// tXg_Co
			MATK_FIX( 100+skill_lv*10, 100);
			break;
		case WZ_FIREPILLAR:	// t@C[s[
			if(mdef1 < 1000000)
				mdef1=mdef2=0;	// MDEF
			MATK_FIX( 1,5 );
			matk1+=50;
			matk2+=50;
			break;
		case WZ_SIGHTRASHER:
			MATK_FIX( 100+skill_lv*20, 100);
			break;
		case WZ_METEOR:
		case WZ_JUPITEL:	// seT_[
			break;
		case WZ_VERMILION:	// [hIuo[~I
			MATK_FIX( skill_lv*20+80, 100 );
			break;
		case WZ_WATERBALL:	// EH[^[{[
			matk1+= skill_lv*30;
			matk2+= skill_lv*30;
			break;
		case WZ_STORMGUST:	// Xg[KXg
			MATK_FIX( skill_lv*40+100 ,100 );
			blewcount|=0x10000;
			break;
		case AL_HOLYLIGHT:	// z[[Cg
			MATK_FIX( 125,100 );
			break;
		case AL_RUWACH:
			MATK_FIX( 145,100 );
			break;
		}
	}

	if(normalmagic_flag){	// ʖ@_[WvZ
		int imdef_flag=0;
		if(matk1>matk2)
			damage= matk2+rand()%(matk1-matk2+1);
		else
			damage= matk2;
		if(sd) {
			if(sd->ignore_mdef_ele & (1<<t_ele) || sd->ignore_mdef_race & (1<<t_race))
				imdef_flag = 1;
			if(t_mode & 0x20) {
				if(sd->ignore_mdef_race & (1<<10))
					imdef_flag = 1;
			}
			else {
				if(sd->ignore_mdef_race & (1<<11))
					imdef_flag = 1;
			}
		}
		if(!imdef_flag){
			if(battle_config.magic_defense_type) {
				damage = damage - (mdef1 * battle_config.magic_defense_type) - mdef2;
			}
			else{
				damage = (damage*(100-mdef1))/100 - mdef2;
			}
		}

		if(damage<1)
			damage=1;
	}

	if(sd) {
		cardfix=100;
		cardfix=cardfix*(100+sd->magic_addrace[t_race])/100;
		cardfix=cardfix*(100+sd->magic_addele[t_ele])/100;
		if(t_mode & 0x20)
			cardfix=cardfix*(100+sd->magic_addrace[10])/100;
		else
			cardfix=cardfix*(100+sd->magic_addrace[11])/100;
		t_class = battle_get_class(target);
		for(i=0;i<sd->add_magic_damage_class_count;i++) {
			if(sd->add_magic_damage_classid[i] == t_class) {
				cardfix=cardfix*(100+sd->add_magic_damage_classrate[i])/100;
				break;
			}
		}
		damage=damage*cardfix/100;
	}

	if( tsd ){
		int s_class = battle_get_class(bl);
		cardfix=100;
		cardfix=cardfix*(100-tsd->subele[ele])/100;	//  ɂ_[Wϐ
		cardfix=cardfix*(100-tsd->subrace[race])/100;	// 푰ɂ_[Wϐ
		cardfix=cardfix*(100-tsd->magic_subrace[race])/100;
		if(battle_get_mode(bl) & 0x20)
			cardfix=cardfix*(100-tsd->magic_subrace[10])/100;
		else
			cardfix=cardfix*(100-tsd->magic_subrace[11])/100;
		for(i=0;i<tsd->add_mdef_class_count;i++) {
			if(tsd->add_mdef_classid[i] == s_class) {
				cardfix=cardfix*(100-tsd->add_mdef_classrate[i])/100;
				break;
			}
		}
		cardfix=cardfix*(100-tsd->magic_def_rate)/100;
		damage=damage*cardfix/100;
	}
	if(damage < 0) damage = 0;

	damage=battle_attr_fix(damage, ele, battle_get_element(target) );		//  C

	if(skill_num == CR_GRANDCROSS) {	// OhNX
		struct Damage wd;
		wd=battle_calc_weapon_attack(bl,target,skill_num,skill_lv,flag);
		damage = (damage + wd.damage) * (100 + 40*skill_lv)/100;
		if(battle_config.gx_dupele) damage=battle_attr_fix(damage, ele, battle_get_element(target) );	//2񂩂
		if(bl==target) damage=damage/2;	//͔
	}

	div_=skill_get_num( skill_num,skill_lv );
	
	if(div_>1 && skill_num != WZ_VERMILION)
		damage*=div_;

//	if(mdef1 >= 1000000 && damage > 0)
	if(t_mode&0x40 && damage > 0)
		damage = 1;

	if( tsd && tsd->special_state.no_magic_damage)
		damage=0;	//  峃J[hi@_[WOj

	damage=battle_calc_damage(bl,target,damage,div_,skill_num,skill_lv,aflag);	// ŏIC

	md.damage=damage;
	md.div_=div_;
	md.amotion=battle_get_amotion(bl);
	md.dmotion=battle_get_dmotion(target);
	md.damage2=0;
	md.type=0;
	md.blewcount=blewcount;
	md.flag=aflag;

	return md;
}

/*==========================================
 * ̑_[WvZ
 *------------------------------------------
 */
struct Damage  battle_calc_misc_attack(
	struct block_list *bl,struct block_list *target,int skill_num,int skill_lv,int flag)
{
	int int_=battle_get_int(bl);
//	int luk=battle_get_luk(bl);
	int dex=battle_get_dex(bl);
	int skill,ele,race,cardfix;
	struct map_session_data *sd=NULL,*tsd=NULL;
	int damage=0,div_=1,blewcount=skill_get_blewcount(skill_num,skill_lv);
	struct Damage md;
	int damagefix=1;

	int aflag=BF_MISC|BF_LONG|BF_SKILL;

	if( bl == NULL || target == NULL ){
		printf("battle_calc_mob_weapon_attack nullpo\n");
		memset(&md,0,sizeof(md));
		return md;
	}

	if(target->type == BL_PET) {
		memset(&md,0,sizeof(md));
		return md;
	}

	if( bl->type == BL_PC && (sd=(struct map_session_data *)bl) ) {
		sd->state.attack_type = BF_MISC;
		sd->state.arrow_atk = 0;
	}

	if( target->type==BL_PC )
		tsd=(struct map_session_data *)target;

	switch(skill_num){

	case HT_LANDMINE:	// h}C
		damage=skill_lv*(dex+75)*(100+int_)/100;
		break;

	case HT_BLASTMINE:	// uXg}C
		damage=skill_lv*(dex/2+50)*(100+int_)/100;
		break;
	
	case HT_CLAYMORETRAP:	// NCA[gbv
		damage=skill_lv*(dex/2+75)*(100+int_)/100;
		break;

	case HT_BLITZBEAT:	// ubcr[g
		if( sd==NULL || (skill = pc_checkskill(sd,HT_STEELCROW)) <= 0)
			skill=0;
		damage=(dex/10+int_/2+skill*3+40)*2;
		if(flag > 1)
			damage /= flag;
		break;

	case TF_THROWSTONE:	// Γ
		damage=30;
		damagefix=0;
		break;

	case BA_DISSONANCE:	// sa
		damage=(skill_lv)*20+pc_checkskill(sd,BA_MUSICALLESSON)*3;
		break;

	case NPC_SELFDESTRUCTION:	// 
		damage=battle_get_hp(bl)-(bl==target?1:0);
		damagefix=0;
		break;

	case NPC_SMOKING:	// ^oRz
		damage=3;
		damagefix=0;
		break;

	case NPC_DARKBREATH:
		{
			struct status_change *sc_data = battle_get_sc_data(target);
			int hitrate=battle_get_hit(bl) - battle_get_flee(target) + 80;
			hitrate = ( (hitrate>95)?95: ((hitrate<5)?5:hitrate) );
			if(sc_data && (sc_data[SC_SLEEP].timer!=-1 || sc_data[SC_STAN].timer!=-1 ||
				sc_data[SC_FREEZE].timer!=-1 || (sc_data[SC_STONE].timer!=-1 && sc_data[SC_STONE].val2==0) ) )
				hitrate = 1000000;
			if(rand()%100 < hitrate) {
				damage = 500 + (skill_lv-1)*1000 + rand()%1000;
				if(damage > 9999) damage = 9999;
			}
		}
		break;
	case SN_FALCONASSAULT:			/* t@RATg */
		damage=(100+50*skill_lv)/100;
		break;
	}

	ele = skill_get_pl(skill_num);
	race = battle_get_race(bl);

	if(damagefix){
		if(damage<1 && skill_num != NPC_DARKBREATH)
			damage=1;

		if( tsd ){
			cardfix=100;
			cardfix=cardfix*(100-tsd->subele[ele])/100;	// ɂ_[Wϐ
			cardfix=cardfix*(100-tsd->subrace[race])/100;	// 푰ɂ_[Wϐ
			cardfix=cardfix*(100-tsd->misc_def_rate)/100;
			damage=damage*cardfix/100;
		}
		if(damage < 0) damage = 0;
		damage=battle_attr_fix(damage, ele, battle_get_element(target) );		// C
	}

	div_=skill_get_num( skill_num,skill_lv );
	if(div_>1)
		damage*=div_;

	if(damage > 0 && (damage < div_ || (battle_get_def(target) >= 1000000 && battle_get_mdef(target) >= 1000000) ) ) {
		damage = div_;
	}

	damage=battle_calc_damage(bl,target,damage,div_,skill_num,skill_lv,aflag);	// ŏIC

	md.damage=damage;
	md.div_=div_;
	md.amotion=battle_get_amotion(bl);
	md.dmotion=battle_get_dmotion(target);
	md.damage2=0;
	md.type=0;
	md.blewcount=blewcount;
	md.flag=aflag;
	return md;

}
/*==========================================
 * _[WvZꊇp
 *------------------------------------------
 */
struct Damage battle_calc_attack(	int attack_type,
	struct block_list *bl,struct block_list *target,int skill_num,int skill_lv,int flag)
{
	struct Damage d;
	switch(attack_type){
	case BF_WEAPON:
		return battle_calc_weapon_attack(bl,target,skill_num,skill_lv,flag);
	case BF_MAGIC:
		return battle_calc_magic_attack(bl,target,skill_num,skill_lv,flag);
	case BF_MISC:
		return battle_calc_misc_attack(bl,target,skill_num,skill_lv,flag);
	default:
		if(battle_config.error_log)
			printf("battle_calc_attack: unknwon attack type ! %d\n",attack_type);
		break;
	}
	return d;
}
/*==========================================
 * ʏU܂Ƃ
 *------------------------------------------
 */
int battle_weapon_attack( struct block_list *src,struct block_list *target,
	 unsigned int tick,int flag)
{
	struct map_session_data *sd=NULL;
	struct status_change *sc_data = battle_get_sc_data(src),*t_sc_data=battle_get_sc_data(target);
	short *opt1;
	int race = 7, ele = 0;
	int damage,rdamage = 0;
	struct Damage wd;

	if( src == NULL || target == NULL ){
		printf("battle_weapon_attack nullpo\n");
		return 0;
	}

	if(src->type == BL_PC)
		sd = (struct map_session_data *)src;

	if(src->prev == NULL || target->prev == NULL)
		return 0;
	if(src->type == BL_PC && pc_isdead(sd))
		return 0;
	if(target->type == BL_PC && pc_isdead((struct map_session_data *)target))
		return 0;

	opt1=battle_get_opt1(src);
	if(opt1 && *opt1 > 0) {
		battle_stopattack(src);
		return 0;
	}
	if(sc_data && sc_data[SC_BLADESTOP].timer!=-1){
		battle_stopattack(src);
		return 0;
	}
	
	race = battle_get_race(target);
	ele = battle_get_elem_type(target);
	if(battle_check_target(src,target,BCT_ENEMY) > 0 &&
		battle_check_range(src,target,0)){
		// UΏۂƂȂ肤̂ōU
		if(sd && sd->status.weapon == 11) {
			if(sd->equip_index[10] >= 0) {
				if(battle_config.arrow_decrement)
					pc_delitem(sd,sd->equip_index[10],1,0);
			}
			else {
				clif_arrow_fail(sd,0);
				return 0;
			}
		}
		if(flag&0x8000) {
			if(sd && battle_config.pc_attack_direction_change)
				sd->dir = sd->head_dir = map_calc_dir(src, target->x,target->y );
			else if(src->type == BL_MOB && battle_config.monster_attack_direction_change)
				((struct mob_data *)src)->dir = map_calc_dir(src, target->x,target->y );
			wd=battle_calc_weapon_attack(src,target,KN_AUTOCOUNTER,flag&0xff,0);
		}
		else
			wd=battle_calc_weapon_attack(src,target,0,0,0);
		if((damage = wd.damage + wd.damage2) > 0 && src != target) {
			if(wd.flag&BF_SHORT) {
				if(target->type == BL_PC) {
					struct map_session_data *tsd = (struct map_session_data *)target;
					if(tsd && tsd->short_weapon_damage_return > 0) {
						rdamage += damage * tsd->short_weapon_damage_return / 100;
						if(rdamage < 1) rdamage = 1;
					}
				}
				if(t_sc_data && t_sc_data[SC_REFLECTSHIELD].timer != -1) {
					rdamage += damage * t_sc_data[SC_REFLECTSHIELD].val2 / 100;
					if(rdamage < 1) rdamage = 1;
				}
			}
			else if(wd.flag&BF_LONG) {
				if(target->type == BL_PC) {
					struct map_session_data *tsd = (struct map_session_data *)target;
					if(tsd && tsd->long_weapon_damage_return > 0) {
						rdamage += damage * tsd->long_weapon_damage_return / 100;
						if(rdamage < 1) rdamage = 1;
					}
				}
			}
			if(rdamage > 0)
				clif_damage(src,src,tick, wd.amotion,0,rdamage,1,4,0);
		}

		if (wd.div_ == 255 && sd)	{ //Oi
			int delay = 1000 - 4 * battle_get_agi(src) - 2 *  battle_get_dex(src);
			int skilllv;
			if(wd.damage+wd.damage2 < battle_get_hp(target)) {
				if((skilllv = pc_checkskill(sd, MO_CHAINCOMBO)) > 0)
					delay += 300 * battle_config.combo_delay_rate /100; //ǉfBCconfɂ蒲

				skill_status_change_start(src,SC_COMBO,MO_TRIPLEATTACK,skilllv,0,0,delay,0);
			}
			sd->attackabletime = sd->canmove_tick = tick + delay;
			clif_combo_delay(src,delay);
			clif_skill_damage(src , target , tick , wd.amotion , wd.dmotion , 
				wd.damage , 3 , MO_TRIPLEATTACK, pc_checkskill(sd,MO_TRIPLEATTACK) , -1 );
		}
		else {
			clif_damage(src,target,tick, wd.amotion, wd.dmotion, 
				wd.damage, wd.div_ , wd.type, wd.damage2);
		//񓁗ƃJ^[ǌ̃~X\(`)
			if(sd && sd->status.weapon >= 16 && wd.damage2 == 0)
				clif_damage(src,target,tick+10, wd.amotion, wd.dmotion,0, 1, 0, 0);
		}
		if(sd && sd->splash_range > 0 && (wd.damage > 0 || wd.damage2 > 0) )
			skill_castend_damage_id(src,target,0,-1,tick,0);
		map_freeblock_lock();
		battle_damage(src,target,(wd.damage+wd.damage2),0);
		if(target->prev != NULL &&
			(target->type != BL_PC || (target->type == BL_PC && !pc_isdead((struct map_session_data *)target) ) ) ) {
			if(wd.damage > 0 || wd.damage2 > 0) {
				skill_additional_effect(src,target,0,0,BF_WEAPON,tick);
				if(sd) {
					if(sd->weapon_coma_ele[ele] > 0 && rand()%10000 < sd->weapon_coma_ele[ele])
						skill_castend_nodamage_id(src,target,SA_COMA,7,tick,0);
					if(sd->weapon_coma_race[race] > 0 && rand()%10000 < sd->weapon_coma_race[race])
						skill_castend_nodamage_id(src,target,SA_COMA,7,tick,0);
					if(battle_get_mode(target) & 0x20) {
						if(sd->weapon_coma_race[10] > 0 && rand()%10000 < sd->weapon_coma_race[10])
							skill_castend_nodamage_id(src,target,SA_COMA,7,tick,0);
					}
					else {
						if(sd->weapon_coma_race[11] > 0 && rand()%10000 < sd->weapon_coma_race[11])
							skill_castend_nodamage_id(src,target,SA_COMA,7,tick,0);
					}
				}
			}
		}
		if(sc_data && sc_data[SC_AUTOSPELL].timer != -1 && rand()%100 < sc_data[SC_AUTOSPELL].val4) {
			int skilllv=sc_data[SC_AUTOSPELL].val3,i,f=0;
			i = rand()%100;
			if(i >= 50) skilllv -= 2;
			else if(i >= 15) skilllv--;
			if(skilllv < 1) skilllv = 1;
			if(sd) {
				int sp = skill_get_sp(sc_data[SC_AUTOSPELL].val2,skilllv)*2/3;
				if(sd->status.sp >= sp) {
					if((i=skill_get_inf(sc_data[SC_AUTOSPELL].val2) == 2) || i == 32)
						f = skill_castend_pos2(src,target->x,target->y,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
					else {
						switch( skill_get_nk(sc_data[SC_AUTOSPELL].val2) ) {
							case 0:	case 2:
								f = skill_castend_damage_id(src,target,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
								break;
							case 1:/* xn */
								if((sc_data[SC_AUTOSPELL].val2==AL_HEAL || (sc_data[SC_AUTOSPELL].val2==ALL_RESURRECTION && target->type != BL_PC)) && battle_check_undead(race,ele))
									f = skill_castend_damage_id(src,target,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
								else
									f = skill_castend_nodamage_id(src,target,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
								break;
						}
					}
					if(!f) pc_heal(sd,0,-sp);
				}
			}
			else {
				if((i=skill_get_inf(sc_data[SC_AUTOSPELL].val2) == 2) || i == 32)
					skill_castend_pos2(src,target->x,target->y,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
				else {
					switch( skill_get_nk(sc_data[SC_AUTOSPELL].val2) ) {
						case 0:	case 2:
							skill_castend_damage_id(src,target,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
							break;
						case 1:/* xn */
							if((sc_data[SC_AUTOSPELL].val2==AL_HEAL || (sc_data[SC_AUTOSPELL].val2==ALL_RESURRECTION && target->type != BL_PC)) && battle_check_undead(race,ele))
								skill_castend_damage_id(src,target,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
							else
								skill_castend_nodamage_id(src,target,sc_data[SC_AUTOSPELL].val2,skilllv,tick,flag);
							break;
					}
				}
			}
		}
		if(sd) {
			if(sd->autospell_id > 0 && sd->autospell_lv > 0 && rand()%100 < sd->autospell_rate) {
				int skilllv=sd->autospell_lv,i,f=0,sp;
				i = rand()%100;
				if(i >= 50) skilllv -= 2;
				else if(i >= 15) skilllv--;
				if(skilllv < 1) skilllv = 1;
				sp = skill_get_sp(sd->autospell_id,skilllv)*2/3;
				if(sd->status.sp >= sp) {
					if((i=skill_get_inf(sd->autospell_id) == 2) || i == 32)
						f = skill_castend_pos2(src,target->x,target->y,sd->autospell_id,skilllv,tick,flag);
					else {
						switch( skill_get_nk(sd->autospell_id) ) {
							case 0:	case 2:
								f = skill_castend_damage_id(src,target,sd->autospell_id,skilllv,tick,flag);
								break;
							case 1:/* xn */
								if((sd->autospell_id==AL_HEAL || (sd->autospell_id==ALL_RESURRECTION && target->type != BL_PC)) && battle_check_undead(race,ele))
									f = skill_castend_damage_id(src,target,sd->autospell_id,skilllv,tick,flag);
								else
									f = skill_castend_nodamage_id(src,target,sd->autospell_id,skilllv,tick,flag);
								break;
						}
					}
					if(!f) pc_heal(sd,0,-sp);
				}
			}
			if(wd.flag&BF_WEAPON && src != target && (wd.damage > 0 || wd.damage2 > 0)) {
				int hp = 0,sp = 0;
				if(sd->hp_drain_rate && sd->hp_drain_per > 0 && wd.damage > 0 && rand()%100 < sd->hp_drain_rate) {
					hp += (wd.damage * sd->hp_drain_per)/100;
					if(sd->hp_drain_rate > 0 && hp < 1) hp = 1;
					else if(sd->hp_drain_rate < 0 && hp > -1) hp = -1;
				}
				if(sd->hp_drain_rate_ && sd->hp_drain_per_ > 0 && wd.damage2 > 0 && rand()%100 < sd->hp_drain_rate_) {
					hp += (wd.damage2 * sd->hp_drain_per_)/100;
					if(sd->hp_drain_rate_ > 0 && hp < 1) hp = 1;
					else if(sd->hp_drain_rate_ < 0 && hp > -1) hp = -1;
				}
				if(sd->sp_drain_rate && sd->sp_drain_per > 0 && wd.damage > 0 && rand()%100 < sd->sp_drain_rate) {
					sp += (wd.damage * sd->sp_drain_per)/100;
					if(sd->sp_drain_rate > 0 && sp < 1) sp = 1;
					else if(sd->sp_drain_rate < 0 && sp > -1) sp = -1;
				}
				if(sd->sp_drain_rate_ && sd->sp_drain_per_ > 0 && wd.damage2 > 0 && rand()%100 < sd->sp_drain_rate_) {
					sp += (wd.damage2 * sd->sp_drain_per_)/100;
					if(sd->sp_drain_rate_ > 0 && sp < 1) sp = 1;
					else if(sd->sp_drain_rate_ < 0 && sp > -1) sp = -1;
				}
				if(hp || sp) pc_heal(sd,hp,sp);
			}
		}

		if(rdamage > 0)
			battle_damage(target,src,rdamage,0);
		if(t_sc_data && t_sc_data[SC_AUTOCOUNTER].timer != -1 && t_sc_data[SC_AUTOCOUNTER].val4 > 0) {
			if(t_sc_data[SC_AUTOCOUNTER].val3 == src->id)
				battle_weapon_attack(target,src,tick,0x8000|t_sc_data[SC_AUTOCOUNTER].val1);
			skill_status_change_end(target,SC_AUTOCOUNTER,-1);
		}
		if(t_sc_data && t_sc_data[SC_BLADESTOP_WAIT].timer != -1){
			int lv = t_sc_data[SC_BLADESTOP_WAIT].val1;
			skill_status_change_end(target,SC_BLADESTOP_WAIT,-1);
			skill_status_change_start(src,SC_BLADESTOP,lv,1,(int)src,(int)target,skill_get_time2(MO_BLADESTOP,lv),0);
			skill_status_change_start(target,SC_BLADESTOP,lv,2,(int)target,(int)src,skill_get_time2(MO_BLADESTOP,lv),0);
		}

		map_freeblock_unlock();
	}
	return wd.dmg_lv;
}

int battle_check_undead(int race,int element)
{
	if(battle_config.undead_detect_type == 0) {
		if(element == 9)
			return 1;
	}
	else if(battle_config.undead_detect_type == 1) {
		if(race == 1)
			return 1;
	}
	else {
		if(element == 9 || race == 1)
			return 1;
	}
	return 0;
}

/*==========================================
 * G(1=m,0=ے,-1=G[)
 * flag&0xf0000 = 0x00000:GȂiret:1Gł͂Ȃj
 *				= 0x10000:p[eB[iret:1=p[eB[o)
 *				= 0x20000:S(ret:1=G)
 *				= 0x40000:G(ret:1=G)
 *				= 0x50000:p[eB[Ȃ(ret:1=p[eBłȂ)
 *------------------------------------------
 */
int battle_check_target( struct block_list *src, struct block_list *target,int flag)
{
	int s_p,s_g,t_p,t_g;
	struct block_list *ss=src;

	if( src == NULL || target == NULL ){
		printf("battle_check_target nullpo\n");
		return 0;
	}

	if( flag&0x40000 ){	// ]tO
		int ret=battle_check_target(src,target,flag&0x30000);
		if(ret!=-1)
			return !ret;
		return -1;
	}

	if( flag&0x20000 ){
		if( target->type==BL_MOB || target->type==BL_PC )
			return 1;
		else
			return -1;
	}
	
	if(src->type == BL_SKILL && target->type == BL_SKILL)	// ΏۂXLjbgȂ疳m
		return -1;

	if(target->type == BL_PC && ((struct map_session_data *)target)->invincible_timer != -1)
		return -1;

	if(target->type == BL_SKILL) {
		switch(((struct skill_unit *)target)->group->unit_id){
		case 0x8d:
		case 0x8f:
		case 0x98:
			return 0;
			break;
		}
	}

	if(target->type == BL_PET)
		return -1;

				// XLjbg̏ꍇAe߂
	if( src->type==BL_SKILL) {
		int inf2 = skill_get_inf2(((struct skill_unit *)src)->group->skill_id);
		if( (ss=map_id2bl( ((struct skill_unit *)src)->group->src_id))==NULL )
			return -1;
		if(ss->prev == NULL)
			return -1;
		if(inf2&0x80	&& map[src->m].flag.pvp && !(target->type == BL_PC && pc_isinvisible((struct map_session_data *)target)))
			return 0;
		if(ss == target) {
			if(inf2&0x100)
				return 0;
			if(inf2&0x200)
				return -1;
		}
	}

	if( src==target || ss==target )	// Ȃm
		return 1;

	if(target->type == BL_PC && pc_isinvisible((struct map_session_data *)target))
		return -1;

	if( src->prev==NULL ||	// łȂG[
		(src->type==BL_PC && pc_isdead((struct map_session_data *)src) ) )
		return -1;

	// Ȃm
	if( ss->type == BL_MOB && ((struct mob_data *)ss)->master_id==target->id )
		return 1;

	if( (ss->type == BL_PC && target->type==BL_MOB) ||
		(ss->type == BL_MOB && target->type==BL_PC) )
		return 0;	// PCvsMOBȂے

	if(ss->type == BL_PET && target->type==BL_MOB)
		return 0;

	s_p=battle_get_party_id(src);
	s_g=battle_get_guild_id(src);

	t_p=battle_get_party_id(target);
	t_g=battle_get_guild_id(target);

	if(flag&0x10000) {
		if(s_p && t_p && s_p == t_p)	// p[eBȂmij
			return 1;
		else		// p[eBȂ瓯p[eBȂ_Ŕے
			return 0;
	}

	if(ss->type == BL_MOB && s_g > 0 && t_g > 0 && s_g == t_g )	// Mh/mobNXȂmij
		return 1;

	if( ss->type==BL_PC && target->type==BL_PC) { //  PVP[hȂےiGj
		if(map[src->m].flag.pvp) {
			if(map[src->m].flag.pvp_noparty && s_p > 0 && t_p > 0 && s_p == t_p)
				return 1;
			else if(map[src->m].flag.pvp_noguild && s_g > 0 && t_g > 0 && s_g == t_g)
				return 1;
			return 0;
		}
		if(map[src->m].flag.gvg) {
			struct guild *g=NULL;
			if( s_g > 0 && s_g == t_g)
				return 1;
			if(map[src->m].flag.gvg_noparty && s_p > 0 && t_p > 0 && s_p == t_p)
				return 1;
			if((g = guild_search(s_g))) {
				int i;
				for(i=0;i<MAX_GUILDALLIANCE;i++){
					if(g->alliance[i].guild_id > 0 &&g->alliance[i].guild_id == t_g) {
						if(g->alliance[i].opposition)
							return 0;//G΃MhȂ疳ɓG
						else
							return 1;//MhȂ疳ɖ
					}
				}
			}
			return 0;
		}
	}

	return 1;	// YȂ̂Ŗ֌Wli܂GȂ̂Ŗj
}
/*==========================================
 * ˒
 *------------------------------------------
 */
int battle_check_range(struct block_list *src,struct block_list *bl,int range)
{

	int dx,dy;
	struct walkpath_data wpd;
	int arange;

	if( src == NULL || bl == NULL ){
		printf("battle_check_range nullpo\n");
		return 0;
	}
	
	dx=abs(bl->x-src->x);
	dy=abs(bl->y-src->y);
	arange=((dx>dy)?dx:dy);

	if(src->m != bl->m)	// Ⴄ}bv
		return 0;
	
	if( range>0 && range < arange )	// 
		return 0;

	if( arange<2 )	// }Xא
		return 1;

//	if(bl->type == BL_SKILL && ((struct skill_unit *)bl)->group->unit_id == 0x8d)
//		return 1;

	// Q
	wpd.path_len=0;
	wpd.path_pos=0;
	wpd.path_half=0;
	if(path_search(&wpd,src->m,src->x,src->y,bl->x,bl->y,0x10001)!=-1)
		return 1;

	dx=(dx>0)?1:((dx<0)?-1:0);
	dy=(dy>0)?1:((dy<0)?-1:0);
	return (path_search(&wpd,src->m,src->x+dx,src->y+dy,
		bl->x-dx,bl->y-dy,0x10001)!=-1)?1:0;
}

/*==========================================
 * ݒt@CǂݍݗpitOj
 *------------------------------------------
 */
int battle_config_switch(const char *str)
{
	if(strcmpi(str,"on")==0 || strcmpi(str,"yes")==0)
		return 1;
	if(strcmpi(str,"off")==0 || strcmpi(str,"no")==0)
		return 0;
	return atoi(str);
}
/*==========================================
 * ݒt@Cǂݍ
 *------------------------------------------
 */
int battle_config_read(const char *cfgName)
{
	int i;
	char line[1024],w1[1024],w2[1024];
	FILE *fp;
	static int count=0;
	
	if( (count++)==0 ){

		battle_config.warp_point_debug=0;
		battle_config.enemy_critical=0;
		battle_config.enemy_critical_rate=100;
		battle_config.enemy_str=1;
		battle_config.enemy_perfect_flee=0;
		battle_config.cast_rate=100;
		battle_config.delay_rate=100;
		battle_config.delay_dependon_dex=0;
		battle_config.sdelay_attack_enable=0;
		battle_config.left_cardfix_to_right=0;
		battle_config.pc_skill_add_range=0;
		battle_config.skill_out_range_consume=1;
		battle_config.mob_skill_add_range=0;
		battle_config.pc_damage_delay=1;
		battle_config.pc_damage_delay_rate=100;
		battle_config.defnotenemy=1;
		battle_config.random_monster_checklv=1;
		battle_config.attr_recover=1;
		battle_config.flooritem_lifetime=LIFETIME_FLOORITEM*1000;
		battle_config.item_auto_get=0;
		battle_config.item_first_get_time=3000;
		battle_config.item_second_get_time=1000;
		battle_config.item_third_get_time=1000;
		battle_config.mvp_item_first_get_time=10000;
		battle_config.mvp_item_second_get_time=10000;
		battle_config.mvp_item_third_get_time=2000;
		battle_config.item_rate=100;
		battle_config.drop_rate0item=0;
		battle_config.base_exp_rate=100;
		battle_config.job_exp_rate=100;
		battle_config.death_penalty_type=0;
		battle_config.death_penalty_base=0;
		battle_config.death_penalty_job=0;
		battle_config.zeny_penalty=0;
		battle_config.restart_hp_rate=0;
		battle_config.restart_sp_rate=0;
		battle_config.mvp_item_rate=100;
		battle_config.mvp_exp_rate=100;
		battle_config.mvp_hp_rate=100;
		battle_config.monster_hp_rate=100;
		battle_config.monster_max_aspd=199;
		battle_config.atc_gmonly=0;
		battle_config.gm_allskill=0;
		battle_config.gm_allequip=0;
		battle_config.gm_skilluncond=0;
		battle_config.skillfree = 0;
		battle_config.skillup_limit = 0;
		battle_config.wp_rate=100;
		battle_config.pp_rate=100;
		battle_config.monster_active_enable=1;
		battle_config.monster_damage_delay_rate=100;
		battle_config.monster_loot_type=0;
		battle_config.mob_skill_use=1;
		battle_config.mob_count_rate=100;
		battle_config.quest_skill_learn=0;
		battle_config.quest_skill_reset=1;
		battle_config.basic_skill_check=1;
		battle_config.guild_emperium_check=1;
		battle_config.guild_exp_limit=50;
		battle_config.pc_invincible_time = 5000;
		battle_config.pet_catch_rate=100;
		battle_config.pet_rename=0;
		battle_config.pet_friendly_rate=100;
		battle_config.pet_hungry_delay_rate=100;
		battle_config.pet_hungry_friendly_decrease=5;
		battle_config.pet_str=1;
		battle_config.pet_status_support=0;
		battle_config.pet_attack_support=0;
		battle_config.pet_damage_support=0;
		battle_config.pet_support_rate=100;
		battle_config.pet_attack_exp_to_master=0;
		battle_config.pet_attack_exp_rate=100;
		battle_config.skill_min_damage=0;
		battle_config.finger_offensive_type=0;
		battle_config.heal_exp=0;
		battle_config.resurrection_exp=0;
		battle_config.shop_exp=0;
		battle_config.combo_delay_rate=100;
		battle_config.item_check=1;
		battle_config.wedding_modifydisplay=0;
		battle_config.natural_healhp_interval=6000;
		battle_config.natural_healsp_interval=8000;
		battle_config.natural_heal_skill_interval=10000;
		battle_config.natural_heal_weight_rate=50;
		battle_config.item_name_override_grffile=1;
		battle_config.arrow_decrement=1;
		battle_config.max_aspd = 199;
		battle_config.max_hp = 32500;
		battle_config.max_sp = 32500;
		battle_config.max_parameter = 99;
		battle_config.max_cart_weight = 8000;
		battle_config.pc_skill_log = 0;
		battle_config.mob_skill_log = 0;
		battle_config.battle_log = 0;
		battle_config.save_log = 0;
		battle_config.error_log = 1;
		battle_config.etc_log = 1;
		battle_config.save_clothcolor = 0;
		battle_config.undead_detect_type = 0;
		battle_config.pc_auto_counter_type = 1;
		battle_config.monster_auto_counter_type = 1;
		battle_config.agi_penaly_type = 0;
		battle_config.agi_penaly_count = 3;
		battle_config.agi_penaly_num = 0;
		battle_config.agi_penaly_count_lv = ATK_FLEE;
		battle_config.vit_penaly_type = 0;
		battle_config.vit_penaly_count = 3;
		battle_config.vit_penaly_num = 0;
		battle_config.vit_penaly_count_lv = ATK_DEF;
		battle_config.player_defense_type = 0;
		battle_config.monster_defense_type = 0;
		battle_config.pet_defense_type = 0;
		battle_config.magic_defense_type = 0;
		battle_config.pc_skill_reiteration = 0;
		battle_config.monster_skill_reiteration = 0;
		battle_config.pc_skill_nofootset = 0;
		battle_config.monster_skill_nofootset = 0;
		battle_config.pc_cloak_check_type = 0;
		battle_config.monster_cloak_check_type = 0;
		battle_config.gvg_short_damage_rate = 100;
		battle_config.gvg_long_damage_rate = 100;
		battle_config.gvg_magic_damage_rate = 100;
		battle_config.gvg_misc_damage_rate = 100;
		battle_config.gvg_eliminate_time = 7000;
		battle_config.mob_changetarget_byskill = 0;
		battle_config.pc_attack_direction_change = 1;
		battle_config.monster_attack_direction_change = 1;
		battle_config.pc_land_skill_limit = 1;
		battle_config.monster_land_skill_limit = 1;
		battle_config.party_skill_penaly = 1;
		battle_config.monster_class_change_full_recover = 0;
		battle_config.produce_item_name_input = 1;
		battle_config.produce_potion_name_input = 1;
		battle_config.making_arrow_name_input = 1;
		battle_config.holywater_name_input = 1;
		battle_config.display_delay_skill_fail = 1;
		battle_config.chat_warpportal = 0;
		battle_config.mob_warpportal = 0;
		battle_config.dead_branch_active = 0;
		battle_config.vending_max_value = 10000000;
		battle_config.pet_lootitem = 0;
		battle_config.pet_weight = 1000;
		battle_config.show_steal_in_same_party = 0;
		battle_config.enable_upper_class = 0;
		battle_config.pet_attack_attr_none = 0;
		battle_config.pc_attack_attr_none = 0;
		battle_config.mob_attack_attr_none = 1;
		battle_config.gx_allhit = 0;
		battle_config.gx_cardfix = 0;
		battle_config.gx_dupele = 1;
		battle_config.gx_disptype = 1;
		battle_config.player_skill_partner_check = 1;
		battle_config.hide_GM_session = 0;
		battle_config.unit_movement_type = 0;
		battle_config.invite_request_check = 1;
	}
	
	fp=fopen(cfgName,"r");
	if(fp==NULL){
		printf("file not found: %s\n",cfgName);
		return 1;
	}
	while(fgets(line,1020,fp)){
		const struct {
			char str[128];
			int *val;
		} data[] ={
			{ "warp_point_debug",			&battle_config.warp_point_debug			},
			{ "enemy_critical",				&battle_config.enemy_critical			},
			{ "enemy_critical_rate",		&battle_config.enemy_critical_rate		},
			{ "enemy_str",					&battle_config.enemy_str				},
			{ "enemy_perfect_flee",			&battle_config.enemy_perfect_flee		},
			{ "casting_rate",				&battle_config.cast_rate				},
			{ "delay_rate",					&battle_config.delay_rate				},
			{ "delay_dependon_dex",			&battle_config.delay_dependon_dex		},
			{ "skill_delay_attack_enable",	&battle_config.sdelay_attack_enable 	},
			{ "left_cardfix_to_right",		&battle_config.left_cardfix_to_right	},
			{ "player_skill_add_range",		&battle_config.pc_skill_add_range		},
			{ "skill_out_range_consume",	&battle_config.skill_out_range_consume	},
			{ "monster_skill_add_range",	&battle_config.mob_skill_add_range		},
			{ "player_damage_delay",		&battle_config.pc_damage_delay			},
			{ "player_damage_delay_rate",	&battle_config.pc_damage_delay_rate		},
			{ "defunit_not_enemy",			&battle_config.defnotenemy				},
			{ "random_monster_checklv",		&battle_config.random_monster_checklv	},
			{ "attribute_recover",			&battle_config.attr_recover				},
			{ "flooritem_lifetime",			&battle_config.flooritem_lifetime		},
			{ "item_auto_get",		&battle_config.item_auto_get		},
			{ "item_first_get_time",		&battle_config.item_first_get_time		},
			{ "item_second_get_time",		&battle_config.item_second_get_time		},
			{ "item_third_get_time",		&battle_config.item_third_get_time		},
			{ "mvp_item_first_get_time",	&battle_config.mvp_item_first_get_time	},
			{ "mvp_item_second_get_time",	&battle_config.mvp_item_second_get_time	},
			{ "mvp_item_third_get_time",	&battle_config.mvp_item_third_get_time	},
			{ "item_rate",					&battle_config.item_rate				},
			{ "drop_rate0item",				&battle_config.drop_rate0item			},
			{ "base_exp_rate",				&battle_config.base_exp_rate			},
			{ "job_exp_rate",				&battle_config.job_exp_rate				},
			{ "death_penalty_type",			&battle_config.death_penalty_type		},
			{ "death_penalty_base",			&battle_config.death_penalty_base		},
			{ "death_penalty_job",			&battle_config.death_penalty_job		},
			{ "zeny_penalty",				&battle_config.zeny_penalty				},
			{ "restart_hp_rate",			&battle_config.restart_hp_rate			},
			{ "restart_sp_rate",			&battle_config.restart_sp_rate			},
			{ "mvp_hp_rate",				&battle_config.mvp_hp_rate				},
			{ "mvp_item_rate",				&battle_config.mvp_item_rate			},
			{ "mvp_exp_rate",				&battle_config.mvp_exp_rate				},
			{ "monster_hp_rate",			&battle_config.monster_hp_rate			},
			{ "monster_max_aspd",			&battle_config.monster_max_aspd			},
			{ "atcommand_gm_only",			&battle_config.atc_gmonly				},
			{ "gm_all_skill",				&battle_config.gm_allskill				},
			{ "gm_all_equipment",			&battle_config.gm_allequip				},
			{ "gm_skill_unconditional",		&battle_config.gm_skilluncond			},
			{ "player_skillfree",			&battle_config.skillfree				},
			{ "player_skillup_limit",		&battle_config.skillup_limit			},
			{ "weapon_produce_rate",		&battle_config.wp_rate					},
			{ "potion_produce_rate",		&battle_config.pp_rate					},
			{ "monster_active_enable",		&battle_config.monster_active_enable	},
			{ "monster_damage_delay_rate",	&battle_config.monster_damage_delay_rate},
			{ "monster_loot_type",			&battle_config.monster_loot_type		},
			{ "mob_skill_use",				&battle_config.mob_skill_use			},
			{ "mob_count_rate",				&battle_config.mob_count_rate			},
			{ "quest_skill_learn",			&battle_config.quest_skill_learn		},
			{ "quest_skill_reset",			&battle_config.quest_skill_reset		},
			{ "basic_skill_check",			&battle_config.basic_skill_check		},
			{ "guild_emperium_check",		&battle_config.guild_emperium_check		},
			{ "guild_exp_limit",			&battle_config.guild_exp_limit			},
			{ "player_invincible_time" ,	&battle_config.pc_invincible_time		},
			{ "pet_catch_rate",				&battle_config.pet_catch_rate			},
			{ "pet_rename",					&battle_config.pet_rename				},
			{ "pet_friendly_rate",			&battle_config.pet_friendly_rate		},
			{ "pet_hungry_delay_rate",		&battle_config.pet_hungry_delay_rate	},
			{ "pet_hungry_friendly_decrease",&battle_config.pet_hungry_friendly_decrease},
			{ "pet_str",					&battle_config.pet_str					},
			{ "pet_status_support",			&battle_config.pet_status_support		},
			{ "pet_attack_support",			&battle_config.pet_attack_support		},
			{ "pet_damage_support",			&battle_config.pet_damage_support		},
			{ "pet_support_rate",			&battle_config.pet_support_rate			},
			{ "pet_attack_exp_to_master",	&battle_config.pet_attack_exp_to_master	},
			{ "pet_attack_exp_rate",		&battle_config.pet_attack_exp_rate	 },
			{ "skill_min_damage",			&battle_config.skill_min_damage			},
			{ "finger_offensive_type",		&battle_config.finger_offensive_type	},
			{ "heal_exp",					&battle_config.heal_exp					},
			{ "resurrection_exp",			&battle_config.resurrection_exp			},
			{ "shop_exp",					&battle_config.shop_exp					},
			{ "combo_delay_rate",			&battle_config.combo_delay_rate			},
			{ "item_check",					&battle_config.item_check				},
			{ "wedding_modifydisplay",		&battle_config.wedding_modifydisplay	},
			{ "natural_healhp_interval",	&battle_config.natural_healhp_interval	},
			{ "natural_healsp_interval",	&battle_config.natural_healsp_interval	},
			{ "natural_heal_skill_interval",&battle_config.natural_heal_skill_interval},
			{ "natural_heal_weight_rate",	&battle_config.natural_heal_weight_rate	},
			{ "item_name_override_grffile",	&battle_config.item_name_override_grffile},
			{ "arrow_decrement",			&battle_config.arrow_decrement			},
			{ "max_aspd",					&battle_config.max_aspd					},
			{ "max_hp",						&battle_config.max_hp					},
			{ "max_sp",						&battle_config.max_sp					},
			{ "max_parameter", 				&battle_config.max_parameter			},
			{ "max_cart_weight",			&battle_config.max_cart_weight			},
			{ "player_skill_log",			&battle_config.pc_skill_log				},
			{ "monster_skill_log",			&battle_config.mob_skill_log			},
			{ "battle_log",					&battle_config.battle_log				},
			{ "save_log",					&battle_config.save_log					},
			{ "error_log",					&battle_config.error_log				},
			{ "etc_log",					&battle_config.etc_log					},
			{ "save_clothcolor",			&battle_config.save_clothcolor			},
			{ "undead_detect_type",			&battle_config.undead_detect_type		},
			{ "player_auto_counter_type",	&battle_config.pc_auto_counter_type		},
			{ "monster_auto_counter_type",	&battle_config.monster_auto_counter_type},
			{ "agi_penaly_type",			&battle_config.agi_penaly_type			},
			{ "agi_penaly_count",			&battle_config.agi_penaly_count			},
			{ "agi_penaly_num",				&battle_config.agi_penaly_num			},
			{ "agi_penaly_count_lv",		&battle_config.agi_penaly_count_lv		},
			{ "vit_penaly_type",			&battle_config.vit_penaly_type			},
			{ "vit_penaly_count",			&battle_config.vit_penaly_count			},
			{ "vit_penaly_num",				&battle_config.vit_penaly_num			},
			{ "vit_penaly_count_lv",		&battle_config.vit_penaly_count_lv		},
			{ "player_defense_type",		&battle_config.player_defense_type		},
			{ "monster_defense_type",		&battle_config.monster_defense_type		},
			{ "pet_defense_type",			&battle_config.pet_defense_type			},
			{ "magic_defense_type",			&battle_config.magic_defense_type		},
			{ "player_skill_reiteration",	&battle_config.pc_skill_reiteration		},
			{ "monster_skill_reiteration",	&battle_config.monster_skill_reiteration},
			{ "player_skill_nofootset",		&battle_config.pc_skill_nofootset		},
			{ "monster_skill_nofootset",	&battle_config.monster_skill_nofootset	},
			{ "player_cloak_check_type",	&battle_config.pc_cloak_check_type		},
			{ "monster_cloak_check_type",	&battle_config.monster_cloak_check_type	},
			{ "gvg_short_attack_damage_rate",&battle_config.gvg_short_damage_rate	},
			{ "gvg_long_attack_damage_rate",&battle_config.gvg_long_damage_rate		},
			{ "gvg_magic_attack_damage_rate",&battle_config.gvg_magic_damage_rate	},
			{ "gvg_misc_attack_damage_rate",&battle_config.gvg_misc_damage_rate		},
			{ "gvg_eliminate_time",			&battle_config.gvg_eliminate_time		},
			{ "mob_changetarget_byskill",	&battle_config.mob_changetarget_byskill},
			{ "player_attack_direction_change",&battle_config.pc_attack_direction_change },
			{ "monster_attack_direction_change",&battle_config.monster_attack_direction_change },
			{ "player_land_skill_limit",	&battle_config.pc_land_skill_limit		},
			{ "monster_land_skill_limit",	&battle_config.monster_land_skill_limit},
			{ "party_skill_penaly",			&battle_config.party_skill_penaly		},
			{ "monster_class_change_full_recover",&battle_config.monster_class_change_full_recover },
			{ "produce_item_name_input",	&battle_config.produce_item_name_input	},
			{ "produce_potion_name_input",	&battle_config.produce_potion_name_input},
			{ "making_arrow_name_input",	&battle_config.making_arrow_name_input	},
			{ "holywater_name_input",		&battle_config.holywater_name_input		},
			{ "display_delay_skill_fail",	&battle_config.display_delay_skill_fail	},
			{ "chat_warpportal", 			&battle_config.chat_warpportal			},
			{ "mob_warpportal", 			&battle_config.mob_warpportal			},
			{ "dead_branch_active", 		&battle_config.dead_branch_active		},
			{ "vending_max_value", 			&battle_config.vending_max_value		},
			{ "pet_lootitem", 				&battle_config.pet_lootitem				},
			{ "pet_weight", 				&battle_config.pet_weight				},
			{ "show_steal_in_same_party", 	&battle_config.show_steal_in_same_party	},
			{ "enable_upper_class", 		&battle_config.enable_upper_class		},
			{ "pet_attack_attr_none", 		&battle_config.pet_attack_attr_none		},
			{ "mob_attack_attr_none", 		&battle_config.mob_attack_attr_none		},
			{ "pc_attack_attr_none", 		&battle_config.pc_attack_attr_none		},
			{ "gx_allhit", 					&battle_config.gx_allhit				},
			{ "gx_cardfix",					&battle_config.gx_cardfix				},
			{ "gx_dupele", 					&battle_config.gx_dupele				},
			{ "gx_disptype", 				&battle_config.gx_disptype				},
			{ "player_skill_partner_check",	&battle_config.player_skill_partner_check},
			{ "hide_GM_session",	&battle_config.hide_GM_session},
			{ "unit_movement_type",	&battle_config.unit_movement_type},
			{ "invite_request_check",	&battle_config.invite_request_check},
		};
		
		if(line[0] == '/' && line[1] == '/')
			continue;
		i=sscanf(line,"%[^:]:%s",w1,w2);
		if(i!=2)
			continue;
		for(i=0;i<sizeof(data)/(sizeof(data[0]));i++)
			if(strcmpi(w1,data[i].str)==0)
				*data[i].val=battle_config_switch(w2);

		if( strcmpi(w1,"import")==0 )
			battle_config_read(w2);
	}
	fclose(fp);

	if(--count==0){
		if(battle_config.flooritem_lifetime < 1000)
			battle_config.flooritem_lifetime = LIFETIME_FLOORITEM*1000;
		if(battle_config.restart_hp_rate < 0)
			battle_config.restart_hp_rate = 0;
		else if(battle_config.restart_hp_rate > 100)
			battle_config.restart_hp_rate = 100;
		if(battle_config.restart_sp_rate < 0)
			battle_config.restart_sp_rate = 0;
		else if(battle_config.restart_sp_rate > 100)
			battle_config.restart_sp_rate = 100;
		if(battle_config.natural_healhp_interval < NATURAL_HEAL_INTERVAL)
			battle_config.natural_healhp_interval=NATURAL_HEAL_INTERVAL;
		if(battle_config.natural_healsp_interval < NATURAL_HEAL_INTERVAL)
			battle_config.natural_healsp_interval=NATURAL_HEAL_INTERVAL;
		if(battle_config.natural_heal_skill_interval < NATURAL_HEAL_INTERVAL)
			battle_config.natural_heal_skill_interval=NATURAL_HEAL_INTERVAL;
		if(battle_config.natural_heal_weight_rate < 50)
			battle_config.natural_heal_weight_rate = 50;
		if(battle_config.natural_heal_weight_rate > 101)
			battle_config.natural_heal_weight_rate = 101;
		battle_config.monster_max_aspd = 2000 - battle_config.monster_max_aspd*10;
		if(battle_config.monster_max_aspd < 10)
			battle_config.monster_max_aspd = 10;
		if(battle_config.monster_max_aspd > 1000)
			battle_config.monster_max_aspd = 1000;
		battle_config.max_aspd = 2000 - battle_config.max_aspd*10;
		if(battle_config.max_aspd < 10)
			battle_config.max_aspd = 10;
		if(battle_config.max_aspd > 1000)
			battle_config.max_aspd = 1000;
		if(battle_config.max_hp > 1000000)
			battle_config.max_hp = 1000000;
		if(battle_config.max_hp < 100)
			battle_config.max_hp = 100;
		if(battle_config.max_sp > 1000000)
			battle_config.max_sp = 1000000;
		if(battle_config.max_sp < 100)
			battle_config.max_sp = 100;
		if(battle_config.max_parameter < 10)
			battle_config.max_parameter = 10;
		if(battle_config.max_parameter > 10000)
			battle_config.max_parameter = 10000;
		if(battle_config.max_cart_weight > 1000000)
			battle_config.max_cart_weight = 1000000;
		if(battle_config.max_cart_weight < 100)
			battle_config.max_cart_weight = 100;
		battle_config.max_cart_weight *= 10;

		if(battle_config.agi_penaly_count < 2)
			battle_config.agi_penaly_count = 2;
		if(battle_config.vit_penaly_count < 2)
			battle_config.vit_penaly_count = 2;

		if(battle_config.guild_exp_limit > 99)
			battle_config.guild_exp_limit = 99;
		if(battle_config.guild_exp_limit < 0)
			battle_config.guild_exp_limit = 0;
		if(battle_config.pet_weight < 0)
			battle_config.pet_weight = 0;

		add_timer_func_list(battle_delay_damage_sub,"battle_delay_damage_sub");
	}
	
	return 0;
}
